/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.integration.mustache.MustacheRenderer;
import schemacrawler.tools.iosource.ClasspathInputResource;
import schemacrawler.tools.iosource.EmptyInputResource;
import schemacrawler.tools.iosource.InputResource;
import schemacrawler.tools.options.OutputOptions;
import sf.util.SchemaCrawlerLogger;

public class MustacheCommandProvider
implements CommandProvider {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(MustacheCommandProvider.class.getName());

    @Override
    public String getDescription() {
        return "Render a Mustache template against a schema";
    }

    @Override
    public InputResource getHelp() {
        String helpResource = "/help/MustacheRenderer.txt";
        try {
            return new ClasspathInputResource("/help/MustacheRenderer.txt");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Could not load help resource <%s>", "/help/MustacheRenderer.txt"), (Throwable)e);
            return new EmptyInputResource();
        }
    }

    @Override
    public Collection<String> getSupportedCommands() {
        return Arrays.asList("mustache");
    }

    @Override
    public SchemaCrawlerCommand newSchemaCrawlerCommand(String command) {
        MustacheRenderer scCommand = new MustacheRenderer();
        return scCommand;
    }

    @Override
    public boolean supportsSchemaCrawlerCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, OutputOptions outputOptions) {
        return "mustache".equals(command);
    }
}

