/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.iosource.FileOutputResource;
import schemacrawler.tools.iosource.OutputResource;
import sf.util.ObjectToString;

public final class OutputOptions
implements Options {
    private final OutputResource outputResource;
    private final String outputFormatValue;
    private final Charset inputEncodingCharset;
    private final Charset outputEncodingCharset;

    OutputOptions(Charset inputEncodingCharset, OutputResource outputResource, Charset outputEncodingCharset, String outputFormatValue) {
        this.inputEncodingCharset = Objects.requireNonNull(inputEncodingCharset, "No input encoding provided");
        this.outputResource = Objects.requireNonNull(outputResource, "No output resource provided");
        this.outputEncodingCharset = Objects.requireNonNull(outputEncodingCharset, "No output encoding provided");
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
    }

    public Charset getInputCharset() {
        return this.inputEncodingCharset;
    }

    public Charset getOutputCharset() {
        return this.outputEncodingCharset;
    }

    public Optional<Path> getOutputFile() {
        Path outputFile = this.outputResource instanceof FileOutputResource ? ((FileOutputResource)this.outputResource).getOutputFile() : null;
        return Optional.ofNullable(outputFile);
    }

    public String getOutputFormatValue() {
        return this.outputFormatValue;
    }

    public Writer openNewOutputWriter() throws IOException {
        return this.openNewOutputWriter(false);
    }

    public Writer openNewOutputWriter(boolean appendOutput) throws IOException {
        return this.outputResource.openNewOutputWriter(this.getOutputCharset(), appendOutput);
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    OutputResource getOutputResource() {
        return this.outputResource;
    }
}

