/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.NamedObject;
import schemacrawler.utility.NamedObjectSort;

abstract class AbstractNamedObject
implements NamedObject {
    private static final long serialVersionUID = -1486322887991472729L;
    private final String name;

    AbstractNamedObject(String name) {
        this.name = name;
    }

    @Override
    public int compareTo(NamedObject obj) {
        if (obj == null) {
            return -1;
        }
        return NamedObjectSort.alphabetical.compare(this, obj);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractNamedObject)) {
            return false;
        }
        return Objects.equals(this.name, ((NamedObject)obj).getName());
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public final String toString() {
        return this.getFullName();
    }

    @Override
    public List<String> toUniqueLookupKey() {
        return new ArrayList<String>(Arrays.asList(this.name));
    }
}

