/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import schemacrawler.crawl.AbstractNamedObjectWithAttributes;
import schemacrawler.crawl.ImmutableDatabaseUser;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableCrawlInfo;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.MutableSynonym;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DatabaseUser;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Reducer;
import schemacrawler.schema.Reducible;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaReference;

final class MutableCatalog
extends AbstractNamedObjectWithAttributes
implements Catalog,
Reducible {
    private static final long serialVersionUID = 4051323422934251828L;
    private final NamedObjectList<MutableColumnDataType> columnDataTypes = new NamedObjectList();
    private final MutableDatabaseInfo databaseInfo;
    private final MutableJdbcDriverInfo jdbcDriverInfo;
    private final NamedObjectList<MutableRoutine> routines = new NamedObjectList();
    private final NamedObjectList<SchemaReference> schemas = new NamedObjectList();
    private final NamedObjectList<MutableSequence> sequences = new NamedObjectList();
    private final NamedObjectList<MutableSynonym> synonyms = new NamedObjectList();
    private final NamedObjectList<MutableTable> tables = new NamedObjectList();
    private final NamedObjectList<ImmutableDatabaseUser> databaseUsers = new NamedObjectList();
    private final MutableCrawlInfo crawlInfo;

    MutableCatalog(String name) {
        super(name);
        this.databaseInfo = new MutableDatabaseInfo();
        this.jdbcDriverInfo = new MutableJdbcDriverInfo();
        this.crawlInfo = new MutableCrawlInfo();
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes() {
        return new ArrayList<ColumnDataType>(this.columnDataTypes.values());
    }

    @Override
    public Collection<ColumnDataType> getColumnDataTypes(Schema schema) {
        FilterBySchema filter = new FilterBySchema(schema);
        ArrayList<ColumnDataType> columnDataTypes = new ArrayList<ColumnDataType>();
        for (ColumnDataType columnDataType : this.columnDataTypes) {
            if (!filter.test(columnDataType)) continue;
            columnDataTypes.add(columnDataType);
        }
        return columnDataTypes;
    }

    @Override
    public CrawlInfo getCrawlInfo() {
        return this.crawlInfo;
    }

    @Override
    public MutableDatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    @Override
    public Collection<DatabaseUser> getDatabaseUsers() {
        return new ArrayList<DatabaseUser>(this.databaseUsers.values());
    }

    @Override
    public MutableJdbcDriverInfo getJdbcDriverInfo() {
        return this.jdbcDriverInfo;
    }

    @Override
    public Collection<Routine> getRoutines() {
        return new ArrayList<Routine>(this.routines.values());
    }

    @Override
    public Collection<Routine> getRoutines(Schema schema) {
        FilterBySchema filter = new FilterBySchema(schema);
        ArrayList<Routine> routines = new ArrayList<Routine>();
        for (Routine routine : this.routines) {
            if (!filter.test(routine)) continue;
            routines.add(routine);
        }
        return routines;
    }

    @Override
    public Collection<Schema> getSchemas() {
        return new ArrayList<Schema>(this.schemas.values());
    }

    @Override
    public Collection<Sequence> getSequences() {
        return new ArrayList<Sequence>(this.sequences.values());
    }

    @Override
    public Collection<Sequence> getSequences(Schema schema) {
        FilterBySchema filter = new FilterBySchema(schema);
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (Sequence sequence : this.sequences) {
            if (!filter.test(sequence)) continue;
            sequences.add(sequence);
        }
        return sequences;
    }

    @Override
    public Collection<Synonym> getSynonyms() {
        return new ArrayList<Synonym>(this.synonyms.values());
    }

    @Override
    public Collection<Synonym> getSynonyms(Schema schema) {
        FilterBySchema filter = new FilterBySchema(schema);
        ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
        for (Synonym synonym : this.synonyms) {
            if (!filter.test(synonym)) continue;
            synonyms.add(synonym);
        }
        return synonyms;
    }

    @Override
    public Collection<ColumnDataType> getSystemColumnDataTypes() {
        return this.getColumnDataTypes(new SchemaReference());
    }

    @Override
    public Collection<Table> getTables() {
        return new ArrayList<Table>(this.tables.values());
    }

    @Override
    public Collection<Table> getTables(Schema schema) {
        FilterBySchema filter = new FilterBySchema(schema);
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Table table : this.tables) {
            if (!filter.test(table)) continue;
            tables.add(table);
        }
        return tables;
    }

    public Optional<MutableColumnDataType> lookupColumnDataType(Schema schema, String name) {
        return this.columnDataTypes.lookup(schema, name);
    }

    public Optional<MutableRoutine> lookupRoutine(Schema schema, String name) {
        return this.routines.lookup(schema, name);
    }

    public Optional<SchemaReference> lookupSchema(String name) {
        if (name == null) {
            return Optional.empty();
        }
        for (SchemaReference schema : this.schemas) {
            if (!name.equals(schema.getFullName())) continue;
            return Optional.of(schema);
        }
        return Optional.empty();
    }

    public Optional<MutableSequence> lookupSequence(Schema schemaRef, String name) {
        return this.sequences.lookup(schemaRef, name);
    }

    public Optional<MutableSynonym> lookupSynonym(Schema schemaRef, String name) {
        return this.synonyms.lookup(schemaRef, name);
    }

    public Optional<MutableColumnDataType> lookupSystemColumnDataType(String name) {
        return this.lookupColumnDataType(new SchemaReference(), name);
    }

    public Optional<MutableTable> lookupTable(List<String> tableLookupKey) {
        return this.tables.lookup(tableLookupKey);
    }

    public Optional<MutableTable> lookupTable(Schema schemaRef, String name) {
        return this.tables.lookup(schemaRef, name);
    }

    @Override
    public <N extends NamedObject> void reduce(Class<N> clazz, Reducer<N> reducer) {
        if (reducer == null) {
            return;
        }
        if (Schema.class.isAssignableFrom(clazz)) {
            reducer.reduce(this.schemas);
        } else if (Table.class.isAssignableFrom(clazz)) {
            reducer.reduce(this.tables);
        } else if (Routine.class.isAssignableFrom(clazz)) {
            reducer.reduce(this.routines);
        } else if (Synonym.class.isAssignableFrom(clazz)) {
            reducer.reduce(this.synonyms);
        } else if (Sequence.class.isAssignableFrom(clazz)) {
            reducer.reduce(this.sequences);
        }
    }

    void addColumnDataType(MutableColumnDataType columnDataType) {
        if (columnDataType != null) {
            this.columnDataTypes.add(columnDataType);
        }
    }

    void addDatabaseUser(ImmutableDatabaseUser databaseUser) {
        this.databaseUsers.add(databaseUser);
    }

    void addRoutine(MutableRoutine routine) {
        this.routines.add(routine);
    }

    Schema addSchema(SchemaReference schema) {
        this.schemas.add(schema);
        return schema;
    }

    Schema addSchema(String catalogName, String schemaName) {
        return this.addSchema(new SchemaReference(catalogName, schemaName));
    }

    void addSequence(MutableSequence sequence) {
        this.sequences.add(sequence);
    }

    void addSynonym(MutableSynonym synonym) {
        this.synonyms.add(synonym);
    }

    void addTable(MutableTable table) {
        this.tables.add(table);
    }

    NamedObjectList<MutableRoutine> getAllRoutines() {
        return this.routines;
    }

    NamedObjectList<SchemaReference> getAllSchemas() {
        return this.schemas;
    }

    NamedObjectList<MutableTable> getAllTables() {
        return this.tables;
    }

    MutableColumnDataType lookupBaseColumnDataTypeByType(int baseType) {
        SchemaReference systemSchema = new SchemaReference();
        MutableColumnDataType columnDataType = null;
        int count = 0;
        for (MutableColumnDataType currentColumnDataType : this.columnDataTypes) {
            if (baseType != currentColumnDataType.getJavaSqlType().getVendorTypeNumber() || !currentColumnDataType.getSchema().equals(systemSchema)) continue;
            columnDataType = currentColumnDataType;
            ++count;
        }
        if (count == 1) {
            return columnDataType;
        }
        return null;
    }

    Optional<MutableRoutine> lookupRoutine(List<String> routineLookupKey) {
        return this.routines.lookup(routineLookupKey);
    }

    void setCrawlInfo() {
        this.crawlInfo.setDatabaseInfo(this.jdbcDriverInfo, this.databaseInfo);
    }

    private static final class FilterBySchema
    implements Predicate<DatabaseObject> {
        private final Schema schema;

        public FilterBySchema(Schema schema) {
            this.schema = Objects.requireNonNull(schema, "No schema provided");
        }

        @Override
        public boolean test(DatabaseObject databaseObject) {
            return databaseObject != null && databaseObject.getSchema().equals(this.schema);
        }
    }
}

