/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableView;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import us.fatehi.utility.graph.DirectedGraph;
import us.fatehi.utility.graph.GraphException;
import us.fatehi.utility.graph.SimpleTopologicalSort;

final class TablesGraph
extends DirectedGraph<Table> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TablesGraph.class.getName());

    TablesGraph(NamedObjectList<MutableTable> tables) {
        super("catalog");
        if (tables == null) {
            return;
        }
        for (Table table : tables) {
            this.addVertex(table);
            for (ForeignKey foreignKey : table.getForeignKeys()) {
                for (ForeignKeyColumnReference columnRef : foreignKey) {
                    this.addEdge((Comparable)columnRef.getPrimaryKeyColumn().getParent(), (Comparable)columnRef.getForeignKeyColumn().getParent());
                }
            }
        }
    }

    void setTablesSortIndexes() {
        try {
            List<Table> sortedTables = this.topologicalSort();
            ArrayList<View> sortedViews = new ArrayList<View>();
            int sortIndex = 0;
            for (Table table : sortedTables) {
                if (table instanceof View) {
                    sortedViews.add((View)table);
                    continue;
                }
                if (!(table instanceof MutableTable)) continue;
                ((MutableTable)table).setSortIndex(sortIndex);
                ++sortIndex;
            }
            for (View view : sortedViews) {
                if (!(view instanceof MutableView)) continue;
                ((MutableView)view).setSortIndex(sortIndex);
                ++sortIndex;
            }
        }
        catch (GraphException e) {
            LOGGER.log(Level.CONFIG, e.getMessage());
        }
    }

    private List<Table> topologicalSort() throws GraphException {
        return new SimpleTopologicalSort<Table>(this).topologicalSort();
    }
}

