/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.analysis.associations.ProposedWeakAssociation;
import schemacrawler.analysis.associations.WeakAssociationsAnalyzer;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.WeakAssociation;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.string.StringFormat;

final class WeakAssociationsRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(WeakAssociationsRetriever.class.getName());
    private final MutableCatalog catalog;

    public WeakAssociationsRetriever(MutableCatalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public void retrieveWeakAssociations() {
        ArrayList<Table> allTables = new ArrayList<Table>(this.catalog.getTables());
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables);
        Collection<ProposedWeakAssociation> proposedWeakAssociations = weakAssociationsAnalyzer.analyzeTables();
        for (ProposedWeakAssociation proposedWeakAssociation : proposedWeakAssociations) {
            this.createWeakAssociation(proposedWeakAssociation);
        }
    }

    private void createWeakAssociation(ProposedWeakAssociation proposedWeakAssociation) {
        LOGGER.log(Level.INFO, new StringFormat("Adding weak association <%s> ", proposedWeakAssociation));
        Column pkColumn = (Column)proposedWeakAssociation.getKey();
        Column fkColumn = (Column)proposedWeakAssociation.getValue();
        boolean isPkColumnPartial = pkColumn instanceof ColumnPartial;
        boolean isFkColumnPartial = fkColumn instanceof ColumnPartial;
        if (pkColumn == null || fkColumn == null || isFkColumnPartial && isPkColumnPartial) {
            return;
        }
        String foreignKeyName = MetaDataUtility.constructForeignKeyName(pkColumn, fkColumn);
        WeakAssociation weakAssociation = new WeakAssociation(foreignKeyName);
        weakAssociation.addColumnReference(pkColumn, fkColumn);
        if (fkColumn instanceof MutableColumn) {
            ((MutableTable)fkColumn.getParent()).addWeakAssociation(weakAssociation);
        }
        if (pkColumn instanceof MutableColumn) {
            ((MutableTable)pkColumn.getParent()).addWeakAssociation(weakAssociation);
        }
    }
}

