/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.diagram;

import java.nio.file.Path;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.diagram.AbstractGraphProcessExecutor;
import schemacrawler.tools.integration.diagram.DiagramOutputFormat;
import schemacrawler.tools.integration.diagram.GraphvizJavaExecutorUtility;
import schemacrawler.tools.integration.diagram.GraphvizUtility;
import us.fatehi.utility.string.StringFormat;

final class GraphvizJavaExecutor
extends AbstractGraphProcessExecutor {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphvizJavaExecutor.class.getName());

    GraphvizJavaExecutor(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat) throws SchemaCrawlerException {
        super(dotFile, outputFile, diagramOutputFormat);
    }

    @Override
    public Boolean call() {
        try {
            GraphvizJavaExecutorUtility.generateGraph(this.dotFile, this.outputFile, this.diagramOutputFormat);
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.INFO, String.format("Could not generate diagram from:%n%s", this.dotFile), (Throwable)e);
            return false;
        }
        LOGGER.log(Level.INFO, new StringFormat("Generated diagram <%s>", this.outputFile));
        return true;
    }

    @Override
    public boolean canGenerate() {
        return GraphvizUtility.isGraphvizJavaAvailable(this.diagramOutputFormat);
    }
}

