/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionRule;
import schemacrawler.schemacrawler.Options;
import schemacrawler.utility.EnumUtility;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class Config
implements Options,
Map<String, String> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(Config.class.getName());
    private final Map<String, String> config = new HashMap<String, String>();

    public static String getSystemConfigurationProperty(String key, String defaultValue) {
        String systemPropertyValue = System.getProperty(key);
        if (!Utility.isBlank(systemPropertyValue)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using value from system property <%s=%s>", key, systemPropertyValue));
            return systemPropertyValue;
        }
        String envVariableValue = System.getenv(key);
        if (!Utility.isBlank(envVariableValue)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using value from enivronmental variable <%s=%s>", key, envVariableValue));
            return envVariableValue;
        }
        return defaultValue;
    }

    private static Map<String, String> propertiesMap(Properties properties) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        if (properties != null) {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entries) {
                propertiesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return propertiesMap;
    }

    public Config() {
    }

    public Config(Map<String, String> config) {
        this();
        if (config != null) {
            this.putAll((Map<? extends String, ? extends String>)config);
        }
    }

    public Config(Properties properties) {
        this(Config.propertiesMap(properties));
    }

    @Override
    public void clear() {
        this.config.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.config.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.config.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.config.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.config.get(key);
    }

    public boolean getBooleanValue(String propertyName) {
        return this.getBooleanValue(propertyName, false);
    }

    public boolean getBooleanValue(String propertyName, boolean defaultValue) {
        return Boolean.parseBoolean(this.getStringValue(propertyName, Boolean.toString(defaultValue)));
    }

    public double getDoubleValue(String propertyName, double defaultValue) {
        try {
            return Double.parseDouble(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse double value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public <E extends Enum<E>> E getEnumValue(String propertyName, E defaultValue) {
        Objects.requireNonNull(defaultValue, "No default value provided");
        String value = this.getStringValue(propertyName, defaultValue.name());
        return EnumUtility.enumValue(value, defaultValue);
    }

    public int getIntegerValue(String propertyName, int defaultValue) {
        try {
            return Integer.parseInt(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse integer value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public long getLongValue(String propertyName, long defaultValue) {
        try {
            return Long.parseLong(this.getStringValue(propertyName, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINEST, new StringFormat("Could not parse long value for property <%s>", propertyName), (Throwable)e);
            return defaultValue;
        }
    }

    public Optional<InclusionRule> getOptionalInclusionRule(String includePatternProperty, String excludePatternProperty) {
        String includePattern = this.getStringValue(includePatternProperty, null);
        String excludePattern = this.getStringValue(excludePatternProperty, null);
        if (Utility.isBlank(includePattern) && Utility.isBlank(excludePattern)) {
            return Optional.empty();
        }
        return Optional.of(new RegularExpressionRule(includePattern, excludePattern));
    }

    public String getStringValue(String propertyName, String defaultValue) {
        String value = this.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public boolean hasValue(String propertyName) {
        return this.config.containsKey(propertyName);
    }

    @Override
    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.config.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.config.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m == null) {
            return;
        }
        this.config.putAll(m);
    }

    public void putAll(Properties properties) {
        this.config.putAll(Config.propertiesMap(properties));
    }

    @Override
    public String remove(Object key) {
        return this.config.remove(key);
    }

    public void setBooleanValue(String propertyName, boolean value) {
        this.put(propertyName, Boolean.toString(value));
    }

    public <E extends Enum<E>> void setEnumValue(String propertyName, E value) {
        if (value == null) {
            this.remove(propertyName);
        } else {
            this.put(propertyName, value.name());
        }
    }

    public void setStringValue(String propertyName, String value) {
        if (value == null) {
            this.remove(propertyName);
        } else {
            this.put(propertyName, value);
        }
    }

    @Override
    public int size() {
        return this.config.size();
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : this.config.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return properties;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }

    @Override
    public Collection<String> values() {
        return this.config.values();
    }
}

