/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.base;

import java.util.Objects;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Options;
import schemacrawler.tools.text.base.BaseTextOptionsBuilder;
import schemacrawler.tools.text.base.DatabaseObjectColorMap;

public abstract class BaseTextOptions
implements Options {
    private final boolean isAlphabeticalSortForTables;
    private final boolean isAlphabeticalSortForTableColumns;
    private final boolean isAlphabeticalSortForRoutines;
    private final boolean isAlphabeticalSortForRoutineParameters;
    private final boolean isNoSchemaCrawlerInfo;
    private final boolean isShowDatabaseInfo;
    private final boolean isShowJdbcDriverInfo;
    private final boolean isShowUnqualifiedNames;
    private final boolean isNoSchemaColors;
    private final IdentifierQuotingStrategy identifierQuotingStrategy;
    private final DatabaseObjectColorMap colorMap;

    protected BaseTextOptions(BaseTextOptionsBuilder<?, ? extends BaseTextOptions> builder) {
        Objects.requireNonNull(builder, "No builder provided");
        this.isAlphabeticalSortForTables = builder.isAlphabeticalSortForTables;
        this.isAlphabeticalSortForTableColumns = builder.isAlphabeticalSortForTableColumns;
        this.isAlphabeticalSortForRoutines = builder.isAlphabeticalSortForRoutines;
        this.isAlphabeticalSortForRoutineParameters = builder.isAlphabeticalSortForRoutineParameters;
        this.isNoSchemaCrawlerInfo = builder.isNoSchemaCrawlerInfo;
        this.isShowDatabaseInfo = builder.isShowDatabaseInfo;
        this.isShowJdbcDriverInfo = builder.isShowJdbcDriverInfo;
        this.isShowUnqualifiedNames = builder.isShowUnqualifiedNames;
        this.isNoSchemaColors = builder.isNoSchemaColors;
        this.identifierQuotingStrategy = builder.identifierQuotingStrategy;
        this.colorMap = DatabaseObjectColorMap.initialize(this.isNoSchemaColors);
    }

    public DatabaseObjectColorMap getColorMap() {
        return this.colorMap;
    }

    public IdentifierQuotingStrategy getIdentifierQuotingStrategy() {
        return this.identifierQuotingStrategy;
    }

    public boolean isAlphabeticalSortForRoutineParameters() {
        return this.isAlphabeticalSortForRoutineParameters;
    }

    public boolean isAlphabeticalSortForRoutines() {
        return this.isAlphabeticalSortForRoutines;
    }

    public boolean isAlphabeticalSortForTableColumns() {
        return this.isAlphabeticalSortForTableColumns;
    }

    public boolean isAlphabeticalSortForTables() {
        return this.isAlphabeticalSortForTables;
    }

    public boolean isNoInfo() {
        return this.isNoSchemaCrawlerInfo && !this.isShowDatabaseInfo && !this.isShowJdbcDriverInfo;
    }

    public boolean isNoSchemaColors() {
        return this.isNoSchemaColors;
    }

    public boolean isNoSchemaCrawlerInfo() {
        return this.isNoSchemaCrawlerInfo;
    }

    public boolean isShowDatabaseInfo() {
        return this.isShowDatabaseInfo;
    }

    public boolean isShowJdbcDriverInfo() {
        return this.isShowJdbcDriverInfo;
    }

    public boolean isShowUnqualifiedNames() {
        return this.isShowUnqualifiedNames;
    }
}

