/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.string.StringFormat;

public class ProcessExecutor
implements Callable<Integer> {
    private static final Logger LOGGER = Logger.getLogger(ProcessExecutor.class.getName());
    private List<String> command;
    private Path processOutput;
    private Path processError;
    private int exitCode;

    @Override
    public Integer call() throws Exception {
        Objects.requireNonNull(this.command, "No command provided");
        try {
            this.processOutput = IOUtility.createTempFilePath("temp", "stdout");
            this.processError = IOUtility.createTempFilePath("temp", "stderr");
            if (this.command.isEmpty()) {
                return null;
            }
            LOGGER.log(Level.CONFIG, new StringFormat("Executing:%n%s", this.command));
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            processBuilder.redirectOutput(this.processOutput.toFile());
            processBuilder.redirectError(this.processError.toFile());
            Process process = processBuilder.start();
            this.exitCode = process.waitFor();
        }
        catch (Throwable t) {
            if (this.exitCode == 0) {
                this.exitCode = Integer.MIN_VALUE;
            }
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
        return this.exitCode;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Path getProcessError() {
        return this.processError;
    }

    public Path getProcessOutput() {
        return this.processOutput;
    }

    public void setCommandLine(List<String> args) {
        this.command = new ArrayList<String>(args);
    }
}

