/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import us.fatehi.utility.ioresource.ClasspathInputResource;
import us.fatehi.utility.ioresource.EmptyInputResource;
import us.fatehi.utility.ioresource.FileInputResource;
import us.fatehi.utility.ioresource.InputResource;

public class InputResourceUtility {
    public static InputResource createInputResource(String inputResourceName) {
        InputResource inputResource = null;
        try {
            Path filePath = Paths.get(inputResourceName, new String[0]);
            inputResource = new FileInputResource(filePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (inputResource == null) {
                inputResource = new ClasspathInputResource(inputResourceName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputResource == null) {
            inputResource = new EmptyInputResource();
        }
        return inputResource;
    }

    public static Reader wrapReader(final String description, Reader reader, final boolean shouldClose) {
        Objects.requireNonNull(reader, "No reader provided");
        return new FilterReader(reader){

            @Override
            public void close() throws IOException {
                if (shouldClose) {
                    super.close();
                }
            }

            public String toString() {
                return description;
            }
        };
    }

    public static Writer wrapWriter(final String description, Writer writer, final boolean shouldClose) {
        Objects.requireNonNull(writer, "No writer provided");
        return new FilterWriter(writer){

            @Override
            public void close() throws IOException {
                if (shouldClose) {
                    super.close();
                } else {
                    super.flush();
                }
            }

            public String toString() {
                return description;
            }
        };
    }

    private InputResourceUtility() {
    }
}

