/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractTableReference;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.schema.Column;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.TableConstraintType;

final class MutableForeignKey
extends AbstractTableReference
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private final String specificName;
    private transient NamedObjectKey key;
    private final StringBuilder definition;
    private ForeignKeyDeferrability deferrability;
    private ForeignKeyUpdateRule deleteRule;
    private ForeignKeyUpdateRule updateRule;

    MutableForeignKey(String name, String specificName) {
        super(name);
        this.specificName = specificName;
        this.definition = new StringBuilder();
        this.updateRule = ForeignKeyUpdateRule.unknown;
        this.deleteRule = ForeignKeyUpdateRule.unknown;
        this.deferrability = ForeignKeyDeferrability.unknown;
    }

    @Override
    public ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public String getSpecificName() {
        return this.specificName;
    }

    @Override
    public TableConstraintType getType() {
        return TableConstraintType.foreign_key;
    }

    @Override
    public ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isDeferrable() {
        return this.isInitiallyDeferred();
    }

    @Override
    public boolean isInitiallyDeferred() {
        if (this.deferrability == null) {
            throw new NotLoadedException(this);
        }
        return this.deferrability == ForeignKeyDeferrability.initiallyDeferred;
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    void addColumnReference(int keySequence, Column pkColumn, Column fkColumn) {
        ImmutableColumnReference fkColumnReference = new ImmutableColumnReference(keySequence, fkColumn, pkColumn);
        this.addColumnReference(fkColumnReference);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = new NamedObjectKey(this.getName(), this.specificName);
    }
}

