/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import schemacrawler.crawl.AbstractDependantObject;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.TablePointer;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;

class MutableTableConstraint
extends AbstractDependantObject<Table>
implements TableConstraint {
    private static final long serialVersionUID = 1155277343302693656L;
    private final NamedObjectList<MutableTableConstraintColumn> columns = new NamedObjectList();
    private final StringBuilder definition = new StringBuilder();
    private boolean deferrable;
    private boolean initiallyDeferred;
    private TableConstraintType tableConstraintType;

    MutableTableConstraint(Table parent, String name) {
        super(new TablePointer(parent), name);
    }

    @Override
    public List<TableConstraintColumn> getConstrainedColumns() {
        return new ArrayList<TableConstraintColumn>(this.columns.values());
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public TableConstraintType getType() {
        if (this.tableConstraintType != null) {
            return this.tableConstraintType;
        }
        return TableConstraintType.unknown;
    }

    @Override
    public boolean hasDefinition() {
        return this.definition.length() > 0;
    }

    @Override
    public boolean isDeferrable() {
        return this.deferrable;
    }

    @Override
    public boolean isInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setTableConstraintType(TableConstraintType tableConstraintType) {
        this.tableConstraintType = tableConstraintType;
    }

    void addColumn(MutableTableConstraintColumn column) {
        this.columns.add(column);
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setDeferrable(boolean deferrable) {
        this.deferrable = deferrable;
    }

    void setInitiallyDeferred(boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }
}

