/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.ColumnPartial;
import schemacrawler.crawl.TablePartial;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class RetrieverUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(RetrieverUtility.class.getName());

    static String constructForeignKeyName(Table pkTable, Table fkTable) {
        Objects.requireNonNull(pkTable, "No referenced table provided");
        Objects.requireNonNull(fkTable, "No referencing table provided");
        String pkHex = Integer.toHexString(pkTable.getFullName().hashCode());
        String fkHex = Integer.toHexString(fkTable.getFullName().hashCode());
        String foreignKeyName = String.format("SC_%s_%s", pkHex, fkHex).toUpperCase();
        return foreignKeyName;
    }

    static Column lookupOrCreateColumn(Catalog catalog, Schema schema, String tableName, String columnName) {
        if (Utility.isBlank(columnName)) {
            return null;
        }
        Objects.requireNonNull(catalog, "No catalog provided");
        Objects.requireNonNull(schema, "No schema provided");
        Column column = null;
        Optional<Column> columnOptional = catalog.lookupColumn(schema, tableName, columnName);
        if (columnOptional.isPresent()) {
            column = columnOptional.get();
        }
        if (column == null) {
            TablePartial table = new TablePartial(schema, tableName);
            column = new ColumnPartial(table, columnName);
            table.addColumn(column);
            LOGGER.log(Level.FINER, new StringFormat("Creating partial column for a column reference <%s>", column));
        }
        return column;
    }

    static Column lookupOrCreateColumn(Catalog catalog, String catalogName, String schemaName, String tableName, String columnName) {
        return RetrieverUtility.lookupOrCreateColumn(catalog, new SchemaReference(catalogName, schemaName), tableName, columnName);
    }

    private RetrieverUtility() {
    }
}

