/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.embeddeddiagram;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.diagram.DiagramRenderer;
import schemacrawler.tools.command.text.diagram.GraphvizUtility;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.SchemaTextRenderer;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import us.fatehi.utility.IOUtility;

public class EmbeddedDiagramRenderer
extends BaseSchemaCrawlerCommand<DiagramOptions> {
    private static final Pattern svgInsertionPoint = Pattern.compile("<h2.*Tables.*h2>");
    private static final Pattern svgStart = Pattern.compile("<svg.*");

    private static void insertSvg(BufferedWriter finalHtmlFileWriter, BufferedReader baseSvgFileReader) throws IOException {
        String line;
        finalHtmlFileWriter.append(System.lineSeparator());
        boolean skipLines = true;
        boolean isSvgStart = false;
        while ((line = baseSvgFileReader.readLine()) != null) {
            if (skipLines) {
                isSvgStart = svgStart.matcher(line).matches();
                boolean bl = skipLines = !isSvgStart;
            }
            if (skipLines) continue;
            if (isSvgStart) {
                line = "<svg";
                isSvgStart = false;
            }
            finalHtmlFileWriter.append(line).append(System.lineSeparator());
        }
        finalHtmlFileWriter.append(System.lineSeparator());
    }

    public EmbeddedDiagramRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizUtility.isGraphvizJavaAvailable(DiagramOutputFormat.svg)) {
            return;
        }
        throw new SchemaCrawlerException("Cannot generate diagram in SVG format");
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Path finalHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseHtmlFile = IOUtility.createTempFilePath("schemacrawler", "html");
        Path baseSvgFile = IOUtility.createTempFilePath("schemacrawler", "svg");
        this.executeCommand(new SchemaTextRenderer(this.command), baseHtmlFile, TextOutputFormat.html);
        this.executeCommand(new DiagramRenderer(this.command), baseSvgFile, DiagramOutputFormat.svg);
        try (BufferedWriter finalHtmlFileWriter = Files.newBufferedWriter(finalHtmlFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             BufferedReader baseHtmlFileReader = Files.newBufferedReader(baseHtmlFile, StandardCharsets.UTF_8);
             BufferedReader baseSvgFileReader = Files.newBufferedReader(baseSvgFile, StandardCharsets.UTF_8);){
            String line;
            while ((line = baseHtmlFileReader.readLine()) != null) {
                if (svgInsertionPoint.matcher(line).matches()) {
                    EmbeddedDiagramRenderer.insertSvg(finalHtmlFileWriter, baseSvgFileReader);
                }
                finalHtmlFileWriter.append(line).append(System.lineSeparator());
            }
        }
        var5_5 = null;
        try (Writer writer = this.outputOptions.openNewOutputWriter();){
            IOUtility.copy(Files.newBufferedReader(finalHtmlFile, StandardCharsets.UTF_8), writer);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    private void executeCommand(SchemaCrawlerCommand<? super DiagramOptions> scCommand, Path outputFile, OutputFormat outputFormat) throws Exception {
        scCommand.setSchemaCrawlerOptions(this.getSchemaCrawlerOptions());
        scCommand.setCommandOptions((DiagramOptions)this.commandOptions);
        scCommand.setIdentifiers(this.getIdentifiers());
        scCommand.setCatalog(this.getCatalog());
        scCommand.setConnection(this.getConnection());
        OutputOptions outputOptions = OutputOptionsBuilder.builder(this.getOutputOptions()).withOutputFormat(outputFormat).withOutputFile(outputFile).toOptions();
        scCommand.setOutputOptions(outputOptions);
        scCommand.checkAvailability();
        scCommand.initialize();
        scCommand.execute();
    }
}

