/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.ioresource.InputResourceUtility;
import us.fatehi.utility.ioresource.OutputResource;

public final class WriterOutputResource
implements OutputResource {
    private static final Logger LOGGER = Logger.getLogger(WriterOutputResource.class.getName());
    private final Writer writer;

    public WriterOutputResource(Writer writer) {
        this.writer = Objects.requireNonNull(writer, "No writer provided");
    }

    @Override
    public Writer openNewOutputWriter(Charset charset, boolean appendOutput) {
        LOGGER.log(Level.INFO, "Output to provided writer");
        return InputResourceUtility.wrapWriter(this.getDescription(), new BufferedWriter(this.writer), false);
    }

    public String toString() {
        return "<writer>";
    }
}

