/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableSequence;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;

final class SequenceRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SequenceRetriever.class.getName());

    SequenceRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveSequenceInformation(InclusionRule sequenceInclusionRule) throws SQLException {
        InclusionRuleFilter<MutableSequence> sequenceFilter = new InclusionRuleFilter<MutableSequence>(sequenceInclusionRule, false);
        if (sequenceFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving sequences, since this was not requested");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving sequences");
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SEQUENCES)) {
            LOGGER.log(Level.FINE, "Sequence definition SQL statement was not provided");
            return;
        }
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        Query sequencesDefinitionSql = informationSchemaViews.getQuery(InformationSchemaKey.SEQUENCES);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(sequencesDefinitionSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("SEQUENCE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("SEQUENCE_SCHEMA"));
                String sequenceName = results.getString("SEQUENCE_NAME");
                BigInteger startValue = results.getBigInteger("START_VALUE");
                BigInteger minimumValue = results.getBigInteger("MINIMUM_VALUE");
                BigInteger maximumValue = results.getBigInteger("MAXIMUM_VALUE");
                BigInteger increment = results.getBigInteger("INCREMENT");
                long longIncrement = increment == null ? 1L : increment.longValue();
                boolean cycle = results.getBoolean("CYCLE_OPTION");
                Optional<SchemaReference> optionalSchema = schemas.lookup(new NamedObjectKey(catalogName, schemaName));
                if (!optionalSchema.isPresent()) continue;
                Schema schema = optionalSchema.get();
                MutableSequence sequence = new MutableSequence(schema, sequenceName);
                sequence.setStartValue(startValue);
                sequence.setMaximumValue(maximumValue);
                sequence.setMinimumValue(minimumValue);
                sequence.setIncrement(longIncrement);
                sequence.setCycle(cycle);
                sequence.addAttributes(results.getAttributes());
                if (!sequenceFilter.test(sequence)) continue;
                this.catalog.addSequence(sequence);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve sequences", e);
        }
    }
}

