/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Utility;

public final class SchemaReference
implements Schema {
    private static final long serialVersionUID = -5309848447599233878L;
    private final Map<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    private final String catalogName;
    private final String schemaName;
    private transient NamedObjectKey key;
    private transient String fullName;

    public SchemaReference() {
        this(null, null);
    }

    public SchemaReference(String catalogName, String schemaName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
    }

    @Override
    public int compareTo(NamedObject obj) {
        return Objects.compare(this, obj, NamedObjectSort.alphabetical);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaReference)) {
            return false;
        }
        Schema other = (Schema)obj;
        return Objects.equals(this.catalogName, other.getCatalogName()) && Objects.equals(this.schemaName, other.getName());
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        Object attributeValue = this.attributeMap.get(name);
        if (attributeValue == null) {
            return defaultValue;
        }
        try {
            return (T)attributeValue;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    @Override
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.schemaName;
    }

    @Override
    public String getRemarks() {
        return "";
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attributeMap.containsKey(name);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName);
    }

    @Override
    public boolean hasRemarks() {
        return false;
    }

    @Override
    public NamedObjectKey key() {
        this.buildKey();
        return this.key;
    }

    @Override
    public <T> Optional<T> lookupAttribute(String name) {
        return Optional.ofNullable(this.getAttribute(name));
    }

    @Override
    public void removeAttribute(String name) {
        if (!Utility.isBlank(name)) {
            this.attributeMap.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (!Utility.isBlank(name)) {
            if (value == null) {
                this.attributeMap.remove(name);
            } else {
                this.attributeMap.put(name, value);
            }
        }
    }

    @Override
    public void setRemarks(String remarks) {
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public void withQuoting(Identifiers identifiers) {
        if (identifiers == null) {
            return;
        }
        this.fullName = identifiers.quoteFullName(this);
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        this.fullName = Identifiers.STANDARD.quoteFullName(this);
    }

    private void buildKey() {
        if (this.key != null) {
            return;
        }
        this.key = new NamedObjectKey(this.catalogName, this.schemaName);
    }
}

