/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.loader.attributes.model;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import schemacrawler.loader.attributes.model.ObjectAttributes;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.Utility;

public class AlternateKeyAttributes
extends ObjectAttributes {
    private static final long serialVersionUID = -3510286847668145323L;
    private final String schemaName;
    private final String catalogName;
    private final String tableName;
    private final List<String> columns;

    @ConstructorProperties(value={"schema", "catalog", "table", "name", "remarks", "attributes", "columns"})
    public AlternateKeyAttributes(String schemaName, String catalogName, String tableName, String name, List<String> remarks, Map<String, String> attributes, List<String> columns) {
        super(name, remarks, attributes);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        if (Utility.isBlank(tableName)) {
            throw new IllegalArgumentException("No table name provided");
        }
        this.tableName = tableName;
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("No columns provided");
        }
        this.columns = Collections.unmodifiableList(columns);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public Schema getSchema() {
        return new SchemaReference(this.catalogName, this.schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String toString() {
        return String.format("Alternate key attributes <%s.%s.%s.%s[%s]>", this.schemaName, this.catalogName, this.tableName, this.getName(), this.columns);
    }
}

