/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.ioresource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.ioresource.InputResourceUtility;

public class ClasspathInputResource
implements InputResource {
    private static final Logger LOGGER = Logger.getLogger(ClasspathInputResource.class.getName());
    private final String classpathResource;

    public ClasspathInputResource(String classpathResource) throws IOException {
        this.classpathResource = Objects.requireNonNull(classpathResource, "No classpath resource provided");
        if (ClasspathInputResource.class.getResource(this.classpathResource) == null) {
            IOException e = new IOException("Cannot read classpath resource, " + this.classpathResource);
            LOGGER.log(Level.FINE, e.getMessage(), e);
            throw e;
        }
    }

    public String getClasspathResource() {
        return this.classpathResource;
    }

    @Override
    public String getDescription() {
        String url;
        try {
            url = ClasspathInputResource.class.getResource(this.classpathResource).toExternalForm();
        }
        catch (Exception e) {
            url = this.classpathResource;
        }
        return url;
    }

    @Override
    public Reader openNewInputReader(Charset charset) {
        Objects.requireNonNull(charset, "No input charset provided");
        InputStream inputStream = ClasspathInputResource.class.getResourceAsStream(this.classpathResource);
        if (inputStream == null) {
            throw new NullPointerException(String.format("Cannot open classpath resource <%s> for reading", this.classpathResource));
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        LOGGER.log(Level.INFO, "Opened input reader to classpath resource, " + this.classpathResource);
        return InputResourceUtility.wrapReader(this.getDescription(), reader, true);
    }

    public String toString() {
        return this.classpathResource;
    }
}

