/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.Query;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.TemplatingUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public final class QueryUtility {
    private static final Logger LOGGER = Logger.getLogger(QueryUtility.class.getName());

    public static ResultSet executeAgainstSchema(Query query, Statement statement, Map<String, InclusionRule> limitMap) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, limitMap);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static ResultSet executeAgainstTable(Query query, Statement statement, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        Objects.requireNonNull(identifiers, "No identifiers provided");
        String sql = QueryUtility.getQuery(query, table, isAlphabeticalSortForTableColumns, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSql(statement, sql);
    }

    public static long executeForLong(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForLong(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    public static Object executeForScalar(Query query, Connection connection, Table table, Identifiers identifiers) throws SQLException {
        Objects.requireNonNull(query, "No query provided");
        String sql = QueryUtility.getQuery(query, table, true, identifiers);
        LOGGER.log(Level.FINE, new StringFormat("Executing %s: %n%s", query.getName(), sql));
        return DatabaseUtility.executeSqlForScalar(connection, sql);
    }

    protected static void addInclusionRule(String limitType, InclusionRule schemaInclusionRule, Map<String, String> properties) {
        String schemaInclusionPattern;
        properties.put(limitType, ".*");
        if (schemaInclusionRule instanceof InclusionRuleWithRegularExpression && !Utility.isBlank(schemaInclusionPattern = ((InclusionRuleWithRegularExpression)schemaInclusionRule).getInclusionPattern().pattern())) {
            properties.put(limitType, schemaInclusionPattern);
        }
    }

    private static String getQuery(Query query) {
        return TemplatingUtility.expandTemplate(query.getQuery());
    }

    private static String getQuery(Query query, Map<String, InclusionRule> limitMap) {
        HashMap<String, String> properties = new HashMap<String, String>();
        Objects.requireNonNull(query, "No query provided");
        Objects.requireNonNull(limitMap, "No limit map provided");
        for (Map.Entry<String, InclusionRule> limit : limitMap.entrySet()) {
            QueryUtility.addInclusionRule(limit.getKey(), limit.getValue(), properties);
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, properties);
        return TemplatingUtility.expandTemplate(sql);
    }

    private static String getQuery(Query query, Table table, boolean isAlphabeticalSortForTableColumns, Identifiers identifiers) {
        HashMap<String, String> tableProperties = new HashMap<String, String>();
        if (table != null) {
            NamedObjectSort columnsSort = NamedObjectSort.getNamedObjectSort(isAlphabeticalSortForTableColumns);
            List<Column> columns = table.getColumns();
            columns.sort(columnsSort);
            Schema schema = table.getSchema();
            if (schema != null) {
                String schemaName = identifiers.quoteFullName(schema);
                tableProperties.put("schema", schemaName);
            }
            tableProperties.put("table", identifiers.quoteFullName(table));
            tableProperties.put("tablename", table.getName());
            tableProperties.put("columns", MetaDataUtility.joinColumns(columns, false, identifiers));
            tableProperties.put("orderbycolumns", MetaDataUtility.joinColumns(columns, true, identifiers));
            tableProperties.put("tabletype", table.getTableType().toString());
        }
        String sql = query.getQuery();
        sql = TemplatingUtility.expandTemplate(sql, tableProperties);
        return TemplatingUtility.expandTemplate(sql);
    }

    private QueryUtility() {
    }
}

