/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.property;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import us.fatehi.utility.Utility;

public final class PropertyName
implements Serializable,
Comparable<PropertyName> {
    private static final long serialVersionUID = 2444083929278551904L;
    private static Comparator<PropertyName> comparator = Comparator.nullsLast(Comparator.comparing(PropertyName::getName, String.CASE_INSENSITIVE_ORDER));
    private final String name;
    private final String description;

    public PropertyName(String name) {
        this(name, null);
    }

    public PropertyName(String name, String description) {
        this.name = Utility.requireNotBlank(name, "Command name not provided").trim();
        this.description = Utility.isBlank(description) ? null : description.trim();
    }

    @Override
    public int compareTo(PropertyName otherProperty) {
        return Objects.compare(this, otherProperty, comparator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PropertyName)) {
            return false;
        }
        PropertyName other = (PropertyName)obj;
        return Objects.equals(this.name, other.name);
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.description != null) {
            builder.append(" - ").append(this.description);
        }
        return builder.toString();
    }
}

