/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Function;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.Procedure;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.SchemaReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class RoutineRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(RoutineRetriever.class.getName());

    RoutineRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveRoutines(Collection<RoutineType> routineTypes, InclusionRule routineInclusionRule) throws SQLException {
        Objects.requireNonNull(routineTypes, "No routine types provided");
        if (routineTypes.contains((Object)RoutineType.procedure)) {
            LOGGER.log(Level.INFO, "Retrieving procedure names");
            this.retrieveProcedures(routineInclusionRule);
        }
        if (routineTypes.contains((Object)RoutineType.function)) {
            LOGGER.log(Level.INFO, "Retrieving function names");
            this.retrieveFunctions(routineInclusionRule);
        }
    }

    private void createFunction(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) {
        String catalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
        String functionName = results.getString("FUNCTION_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving function <%s.%s.%s>", catalogName, schemaName, functionName));
        if (Utility.isBlank(functionName)) {
            return;
        }
        FunctionReturnType functionType = results.getEnumFromShortId("FUNCTION_TYPE", FunctionReturnType.unknown);
        String remarks = results.getString("REMARKS");
        String specificName = results.getString("SPECIFIC_NAME");
        Optional<SchemaReference> optionalSchema = schemas.lookup(new NamedObjectKey(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = optionalSchema.get();
        MutableFunction function = new MutableFunction(schema, functionName, specificName);
        if (functionFilter.test(function)) {
            function.setReturnType(functionType);
            function.setRemarks(remarks);
            function.addAttributes(results.getAttributes());
            this.catalog.addRoutine(function);
        }
    }

    private void createProcedure(MetadataResultSet results, NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) {
        String catalogName = this.normalizeCatalogName(results.getString("PROCEDURE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("PROCEDURE_SCHEM"));
        String procedureName = results.getString("PROCEDURE_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving procedure <%s.%s.%s>", catalogName, schemaName, procedureName));
        if (Utility.isBlank(procedureName)) {
            return;
        }
        ProcedureReturnType procedureType = results.getEnumFromShortId("PROCEDURE_TYPE", ProcedureReturnType.unknown);
        String remarks = results.getString("REMARKS");
        String specificName = results.getString("SPECIFIC_NAME");
        Optional<SchemaReference> optionalSchema = schemas.lookup(new NamedObjectKey(catalogName, schemaName));
        if (!optionalSchema.isPresent()) {
            return;
        }
        Schema schema = optionalSchema.get();
        MutableProcedure procedure = new MutableProcedure(schema, procedureName, specificName);
        if (procedureFilter.test(procedure)) {
            procedure.setReturnType(procedureType);
            procedure.setRemarks(remarks);
            procedure.addAttributes(results.getAttributes());
            this.catalog.addRoutine(procedure);
        }
    }

    private void retrieveFunctions(InclusionRule routineInclusionRule) throws SQLException {
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        InclusionRuleFilter<Function> functionFilter = new InclusionRuleFilter<Function>(routineInclusionRule, false);
        if (functionFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving functions, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.functionsRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving functions, using fast data dictionary retrieval");
                this.retrieveFunctionsFromDataDictionary(schemas, functionFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving functions");
                this.retrieveFunctionsFromMetadata(schemas, functionFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving functions");
            }
        }
    }

    private void retrieveFunctionsFromDataDictionary(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FUNCTIONS)) {
            throw new ExecutionRuntimeException("No functions SQL provided");
        }
        Query functionsSql = informationSchemaViews.getQuery(InformationSchemaKey.FUNCTIONS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(functionsSql, statement, this.getLimitMap());){
            int count = 0;
            while (results.next()) {
                ++count;
                this.createFunction(results, schemas, functionFilter);
            }
            LOGGER.log(Level.INFO, new StringFormat("Processed %d functions", count));
        }
    }

    private void retrieveFunctionsFromMetadata(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Function> functionFilter) {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving functions for schema <%s>", schema));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            try {
                Connection connection = this.getRetrieverConnection().getConnection();
                Throwable throwable = null;
                try {
                    MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getFunctions(catalogName, schemaName, null), "DatabaseMetaData::getFunctions");
                    Throwable throwable2 = null;
                    try {
                        int count = 0;
                        while (results.next()) {
                            ++count;
                            this.createFunction(results, schemas, functionFilter);
                        }
                        LOGGER.log(Level.INFO, new StringFormat("Processed %d functions in schema <%s>", count, schema));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable2 != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (AbstractMethodError e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve functions", new Object[0]), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve functions", new Object[0]), e);
            }
        }
    }

    private void retrieveProcedures(InclusionRule routineInclusionRule) throws SQLException {
        NamedObjectList<SchemaReference> schemas = this.getAllSchemas();
        InclusionRuleFilter<Procedure> procedureFilter = new InclusionRuleFilter<Procedure>(routineInclusionRule, false);
        if (procedureFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving procedures, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.proceduresRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving procedures, using fast data dictionary retrieval");
                this.retrieveProceduresFromDataDictionary(schemas, procedureFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving procedures");
                this.retrieveProceduresFromMetadata(schemas, procedureFilter);
                break;
            }
        }
    }

    private void retrieveProceduresFromDataDictionary(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.PROCEDURES)) {
            throw new ExecutionRuntimeException("No procedures SQL provided");
        }
        Query proceduresSql = informationSchemaViews.getQuery(InformationSchemaKey.PROCEDURES);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(proceduresSql, statement, this.getLimitMap());){
            int count = 0;
            while (results.next()) {
                ++count;
                this.createProcedure(results, schemas, procedureFilter);
            }
            LOGGER.log(Level.INFO, new StringFormat("Processed %d procedures", count));
        }
    }

    private void retrieveProceduresFromMetadata(NamedObjectList<SchemaReference> schemas, InclusionRuleFilter<Procedure> procedureFilter) throws SQLException {
        for (Schema schema : schemas) {
            LOGGER.log(Level.INFO, new StringFormat("Retrieving procedures for schema <%s>", schema));
            String catalogName = schema.getCatalogName();
            String schemaName = schema.getName();
            try {
                Connection connection = this.getRetrieverConnection().getConnection();
                Throwable throwable = null;
                try {
                    MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getProcedures(catalogName, schemaName, null), "DatabaseMetaData::getProcedures");
                    Throwable throwable2 = null;
                    try {
                        int count = 0;
                        while (results.next()) {
                            ++count;
                            this.createProcedure(results, schemas, procedureFilter);
                        }
                        LOGGER.log(Level.INFO, new StringFormat("Processed %d procedures in schema <%s>", count, schema));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable2 != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve procedures", new Object[0]), e);
            }
        }
    }
}

