/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import schemacrawler.tools.registry.BasePluginRegistry;
import us.fatehi.utility.property.PropertyName;

public class ScriptEngineRegistry
extends BasePluginRegistry {
    private static final Logger LOGGER = Logger.getLogger(ScriptEngineRegistry.class.getName());
    private static ScriptEngineRegistry scriptEngineRegistrySingleton;
    private final Collection<PropertyName> scriptEngines = ScriptEngineRegistry.loadScriptEngines();

    public static ScriptEngineRegistry getScriptEngineRegistry() {
        if (scriptEngineRegistrySingleton == null) {
            scriptEngineRegistrySingleton = new ScriptEngineRegistry();
        }
        scriptEngineRegistrySingleton.log();
        return scriptEngineRegistrySingleton;
    }

    private static List<PropertyName> loadScriptEngines() {
        CopyOnWriteArrayList<PropertyName> availableScriptEngines = new CopyOnWriteArrayList<PropertyName>();
        try {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
            for (ScriptEngineFactory scriptEngineFactory : engineFactories) {
                if (scriptEngineFactory == null) continue;
                availableScriptEngines.add(new PropertyName(String.format("%s %s", scriptEngineFactory.getEngineName(), scriptEngineFactory.getExtensions()), scriptEngineFactory.getEngineVersion()));
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Could not load script engines", e);
        }
        Collections.sort(availableScriptEngines);
        return availableScriptEngines;
    }

    private ScriptEngineRegistry() {
    }

    @Override
    public Collection<PropertyName> getRegisteredPlugins() {
        return new ArrayList<PropertyName>(this.scriptEngines);
    }

    @Override
    public String getName() {
        return "Script Engines";
    }
}

