/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.crawl.ImmutableDatabaseUser;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.crawl.ImmutableServerInfoProperty;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableDatabaseInfo;
import schemacrawler.crawl.MutableJdbcDriverInfo;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

final class DatabaseInfoRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(DatabaseInfoRetriever.class.getName());
    private static final List<String> ignoreMethods = Arrays.asList("getDatabaseProductName", "getDatabaseProductVersion", "getURL", "getUserName", "getDriverName", "getDriverVersion");

    private static boolean isDatabasePropertiesResultSetMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(ResultSet.class) && method.getParameterTypes().length == 0;
    }

    private static boolean isDatabasePropertyListMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(String.class) && method.getName().endsWith("s") && method.getParameterTypes().length == 0;
    }

    private static boolean isDatabasePropertyMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean notPropertyMethod = returnType.equals(ResultSet.class) || returnType.equals(Connection.class) || method.getParameterTypes().length > 0;
        return !notPropertyMethod;
    }

    private static ImmutableDatabaseProperty retrieveResultSetTypeProperty(DatabaseMetaData dbMetaData, Method method, int resultSetType, String resultSetTypeName) throws IllegalAccessException, InvocationTargetException {
        String name = method.getName() + "For" + resultSetTypeName + "ResultSets";
        Boolean propertyValue = (Boolean)method.invoke((Object)dbMetaData, resultSetType);
        return new ImmutableDatabaseProperty(name, (Object)propertyValue);
    }

    DatabaseInfoRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveAdditionalDatabaseInfo() {
        try (Connection connection = this.getRetrieverConnection().getConnection();){
            Method[] methods;
            DatabaseMetaData dbMetaData = connection.getMetaData();
            MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
            ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
            for (Method method : methods = DatabaseMetaData.class.getMethods()) {
                try {
                    String methodName = method.getName();
                    if (method.getParameterTypes().length > 0 || ignoreMethods.contains(methodName)) continue;
                    LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                    Object methodReturnValue = method.invoke((Object)dbMetaData, new Object[0]);
                    if (DatabaseInfoRetriever.isDatabasePropertyListMethod(method)) {
                        String value = (String)methodReturnValue;
                        String[] valuesArray = value == null ? new String[]{} : value.split(",");
                        ArrayList<String> valuesList = new ArrayList<String>();
                        for (String valueSplit : valuesArray) {
                            String trimmedValue = Utility.trimToEmpty(valueSplit);
                            if (trimmedValue.isEmpty()) continue;
                            valuesList.add(trimmedValue);
                        }
                        Collections.sort(valuesList);
                        dbProperties.add(new ImmutableDatabaseProperty(methodName, Collections.unmodifiableList(valuesList)));
                        continue;
                    }
                    if (DatabaseInfoRetriever.isDatabasePropertyMethod(method)) {
                        dbProperties.add(new ImmutableDatabaseProperty(methodName, methodReturnValue));
                        continue;
                    }
                    if (!DatabaseInfoRetriever.isDatabasePropertiesResultSetMethod(method)) continue;
                    ResultSet results = (ResultSet)methodReturnValue;
                    List<String> valuesList = DatabaseUtility.readResultsVector(results);
                    Collections.sort(valuesList);
                    dbProperties.add(new ImmutableDatabaseProperty(methodName, Collections.unmodifiableList(valuesList)));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.log(Level.FINE, e.getCause(), new StringFormat("Could not execute method <%s>", method));
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                    this.logSQLFeatureNotSupported(new StringFormat("Database metadata method <%s> not supported", method), e);
                }
                catch (SQLException e) {
                    this.logPossiblyUnsupportedSQLFeature(new StringFormat("SQL exception invoking method <%s>", method), e);
                }
            }
            Collection<ImmutableDatabaseProperty> resultSetTypesProperties = this.retrieveResultSetTypesProperties(dbMetaData);
            dbProperties.addAll(resultSetTypesProperties);
            dbInfo.addAll(dbProperties);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain additional database information", e);
        }
    }

    void retrieveAdditionalJdbcDriverInfo() {
        MutableJdbcDriverInfo driverInfo = this.catalog.getJdbcDriverInfo();
        if (driverInfo == null) {
            return;
        }
        try (Connection connection = this.getRetrieverConnection().getConnection();){
            DriverPropertyInfo[] propertyInfo;
            DatabaseMetaData dbMetaData = connection.getMetaData();
            String url = dbMetaData.getURL();
            Driver jdbcDriver = DriverManager.getDriver(dbMetaData.getURL());
            if (jdbcDriver == null) {
                throw new SQLException("No JDBC driver found");
            }
            for (DriverPropertyInfo driverPropertyInfo : propertyInfo = jdbcDriver.getPropertyInfo(url, new Properties())) {
                driverInfo.addJdbcDriverProperty(new ImmutableJdbcDriverProperty(driverPropertyInfo));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not obtain additional JDBC driver information", e);
        }
    }

    void retrieveDatabaseUsers() {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.DATABASE_USERS)) {
            LOGGER.log(Level.INFO, "Not retrieving database users information, since this was not requested");
            LOGGER.log(Level.FINE, "Database users SQL statement was not provided");
            return;
        }
        Query databaseUsersSql = informationSchemaViews.getQuery(InformationSchemaKey.DATABASE_USERS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(databaseUsersSql, statement, new HashMap<String, InclusionRule>());){
            while (results.next()) {
                String username = results.getString("USERNAME");
                if (Utility.isBlank(username)) continue;
                LOGGER.log(Level.FINER, new StringFormat("Retrieving database user name: %s", username));
                ImmutableDatabaseUser databaseUser = new ImmutableDatabaseUser(username);
                databaseUser.addAttributes(results.getAttributes());
                this.catalog.addDatabaseUser(databaseUser);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve database users", e);
        }
    }

    void retrieveServerInfo() {
        MutableDatabaseInfo dbInfo = this.catalog.getDatabaseInfo();
        if (dbInfo == null) {
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SERVER_INFORMATION)) {
            LOGGER.log(Level.INFO, "Not retrieving server information, since this was not requested");
            LOGGER.log(Level.FINE, "Server information SQL statement was not provided");
            return;
        }
        Query serverInfoSql = informationSchemaViews.getQuery(InformationSchemaKey.SERVER_INFORMATION);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(serverInfoSql, statement, new HashMap<String, InclusionRule>());){
            while (results.next()) {
                String propertyName = results.getString("NAME");
                if (Utility.isBlank(propertyName)) continue;
                String propertyValue = results.getString("VALUE");
                String propertyDescription = results.getString("DESCRIPTION");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving server information property: %s=%s", propertyName, propertyValue));
                ImmutableServerInfoProperty serverInfoProperty = new ImmutableServerInfoProperty(propertyName, propertyValue, propertyDescription);
                dbInfo.addServerInfo(serverInfoProperty);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve server information", e);
        }
    }

    private Collection<ImmutableDatabaseProperty> retrieveResultSetTypesProperties(DatabaseMetaData dbMetaData) {
        String[] resultSetTypesMethods;
        ArrayList<ImmutableDatabaseProperty> dbProperties = new ArrayList<ImmutableDatabaseProperty>();
        for (String methodName : resultSetTypesMethods = new String[]{"deletesAreDetected", "insertsAreDetected", "updatesAreDetected", "othersInsertsAreVisible", "othersDeletesAreVisible", "othersUpdatesAreVisible", "ownDeletesAreVisible", "ownInsertsAreVisible", "ownUpdatesAreVisible", "supportsResultSetType"}) {
            try {
                Method method = DatabaseMetaData.class.getMethod(methodName, Integer.TYPE);
                LOGGER.log(Level.FINER, new StringFormat("Retrieving database property using method <%s>", method));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1003, "TYPE_FORWARD_ONLY"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1004, "TYPE_SCROLL_INSENSITIVE"));
                dbProperties.add(DatabaseInfoRetriever.retrieveResultSetTypeProperty(dbMetaData, method, 1005, "TYPE_SCROLL_SENSITIVE"));
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e.getCause(), new StringFormat("Could not execute method <%s>", methodName));
            }
        }
        return dbProperties;
    }
}

