/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.associations;

import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import sf.util.Multimap;

final class ColumnMatchKeysMap {
    private final Multimap<String, Column> columnsForMatchKey;
    private final Multimap<Column, String> matchKeysForColumn;

    ColumnMatchKeysMap(List<Table> tables) {
        Objects.requireNonNull(tables, "No tables provided");
        this.columnsForMatchKey = new Multimap();
        this.matchKeysForColumn = new Multimap();
        for (Table table : tables) {
            this.mapColumnNameMatches(table);
        }
    }

    public boolean containsKey(Column column) {
        return this.matchKeysForColumn.containsKey(column);
    }

    public boolean containsKey(String columnKey) {
        return this.columnsForMatchKey.containsKey(columnKey);
    }

    public List<String> get(Column column) {
        return (List)this.matchKeysForColumn.get(column);
    }

    public List<Column> get(String matchKey) {
        return (List)this.columnsForMatchKey.get(matchKey);
    }

    public String toString() {
        return this.columnsForMatchKey.toString();
    }

    private void mapColumnNameMatches(Table table) {
        for (Column column : table.getColumns()) {
            String matchColumnName = column.getName().toLowerCase();
            if (matchColumnName.endsWith("_id")) {
                matchColumnName = matchColumnName.substring(0, matchColumnName.length() - 3);
            }
            if (matchColumnName.endsWith("id") && !matchColumnName.equals("id")) {
                matchColumnName = matchColumnName.substring(0, matchColumnName.length() - 2);
            }
            if (matchColumnName.equals("id")) continue;
            this.columnsForMatchKey.add(matchColumnName, column);
            this.matchKeysForColumn.add(column, matchColumnName);
        }
    }
}

