/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import schemacrawler.analysis.associations.Inflection;
import schemacrawler.schema.Table;
import sf.util.Multimap;
import sf.util.ObjectToString;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class TableMatchKeys {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableMatchKeys.class.getName());
    private final List<Table> tables;
    private final Multimap<Table, String> tableKeys;

    TableMatchKeys(List<Table> tables) {
        this.tables = Objects.requireNonNull(tables, "No tables provided");
        this.tableKeys = new Multimap();
        this.analyzeTables();
    }

    public List<String> get(Table table) {
        return (List)this.tableKeys.get(table);
    }

    public String toString() {
        return this.tableKeys.toString();
    }

    private void analyzeTables() {
        if (this.tables.isEmpty()) {
            return;
        }
        Collection<String> prefixes = this.findTableNamePrefixes(this.tables);
        this.mapTableNameMatches(this.tables, prefixes);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, new StringFormat("Table prefixes=%s", prefixes));
            LOGGER.log(Level.FINE, new StringFormat("Table matches map: %s", ObjectToString.toString(this.tableKeys)));
        }
    }

    private Collection<String> findTableNamePrefixes(List<Table> tables) {
        TreeMap<String, Integer> prefixesMap = new TreeMap<String, Integer>();
        for (int i = 0; i < tables.size(); ++i) {
            for (int j = i + 1; j < tables.size(); ++j) {
                String table2;
                String table1 = tables.get(i).getName();
                String commonPrefix = Utility.commonPrefix(table1, table2 = tables.get(j).getName());
                if (Utility.isBlank(commonPrefix) || !commonPrefix.endsWith("_")) continue;
                ArrayList<String> splitCommonPrefixes = new ArrayList<String>();
                String[] splitPrefix = commonPrefix.split("_");
                if (splitPrefix != null && splitPrefix.length > 0) {
                    for (int k = 0; k < splitPrefix.length; ++k) {
                        StringBuilder buffer = new StringBuilder(1024);
                        for (int l = 0; l < k; ++l) {
                            buffer.append(splitPrefix[l]).append("_");
                        }
                        if (buffer.length() <= 0) continue;
                        splitCommonPrefixes.add(buffer.toString());
                    }
                }
                splitCommonPrefixes.add(commonPrefix);
                for (String splitCommonPrefix : splitCommonPrefixes) {
                    int prevCount = prefixesMap.containsKey(splitCommonPrefix) ? (Integer)prefixesMap.get(splitCommonPrefix) : 0;
                    prefixesMap.put(splitCommonPrefix, prevCount + 1);
                }
            }
        }
        ArrayList keySet = new ArrayList(prefixesMap.keySet());
        keySet.sort((key1, key2) -> {
            int comparison = 0;
            comparison = key2.length() - key1.length();
            if (comparison == 0) {
                comparison = key2.compareTo((String)key1);
            }
            return comparison;
        });
        block5: for (int i = 0; i < keySet.size(); ++i) {
            for (int j = i + 1; j < keySet.size(); ++j) {
                String longPrefix = (String)keySet.get(i);
                if (!longPrefix.startsWith((String)keySet.get(j))) continue;
                prefixesMap.remove(longPrefix);
                continue block5;
            }
        }
        ArrayList prefixesList = new ArrayList(prefixesMap.entrySet());
        Collections.sort(prefixesList, (entry1, entry2) -> ((Integer)entry1.getValue()).compareTo((Integer)entry2.getValue()));
        ArrayList<String> prefixes = new ArrayList<String>();
        for (int i = 0; i < prefixesList.size(); ++i) {
            boolean add;
            boolean bl = add = i < 5 || (double)((Integer)((Map.Entry)prefixesList.get(i)).getValue()).intValue() > (double)prefixesMap.size() * 0.5;
            if (!add) continue;
            prefixes.add((String)((Map.Entry)prefixesList.get(i)).getKey());
        }
        prefixes.add("");
        return prefixes;
    }

    private void mapTableNameMatches(List<Table> tables, Collection<String> prefixes) {
        for (Table table : tables) {
            for (String prefix : prefixes) {
                String matchTableName = table.getName().toLowerCase();
                if (!matchTableName.startsWith(prefix)) continue;
                matchTableName = matchTableName.substring(prefix.length());
                if (Utility.isBlank(matchTableName = Inflection.singularize(matchTableName))) continue;
                this.tableKeys.add(table, matchTableName);
            }
        }
    }
}

