/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.counts;

import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.analysis.counts.TableRowCountsUtility;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public class TableRowCountsFilter
implements Predicate<Table> {
    private final boolean noEmptyTables;

    public TableRowCountsFilter(SchemaCrawlerOptions options) {
        Objects.requireNonNull(options, "No SchemaCrawlerOptions provided");
        this.noEmptyTables = options.isNoEmptyTables();
    }

    @Override
    public boolean test(Table table) {
        long count;
        boolean hideTable = this.noEmptyTables ? (count = TableRowCountsUtility.getRowCount(table)) == 0L : false;
        return !hideTable;
    }
}

