/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.analysis.counts;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.analysis.counts.TableRowCountsUtility;
import schemacrawler.crawl.Retriever;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.Query;
import schemacrawler.utility.QueryUtility;
import sf.util.DatabaseUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;

public final class TableRowCountsRetriever
implements Retriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableRowCountsRetriever.class.getName());
    private final Connection connection;
    private final Catalog catalog;

    public TableRowCountsRetriever(Connection connection, Catalog catalog) throws SchemaCrawlerSQLException {
        this.connection = DatabaseUtility.checkConnection(connection);
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
    }

    public void retrieveTableRowCounts() {
        Identifiers identifiers;
        try {
            identifiers = Identifiers.identifiers().withConnection(this.connection).build();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "No connection provided", (Throwable)e);
            Identifiers identifiers2 = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
            return;
        }
        Query query = new Query("schemacrawler.table.row_counts", "SELECT COUNT(*) FROM ${table}");
        ArrayList<Table> allTables = new ArrayList<Table>(this.catalog.getTables());
        for (Table table : allTables) {
            try {
                long count = QueryUtility.executeForLong(query, this.connection, table, identifiers);
                TableRowCountsUtility.addRowCountToTable(table, count);
            }
            catch (SchemaCrawlerException e) {
                LOGGER.log(Level.WARNING, new StringFormat("Could not get count for table <%s>", table), (Throwable)e);
            }
        }
    }
}

