/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumnDataType;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.Retriever;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.utility.TypeMap;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

abstract class AbstractRetriever
implements Retriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(AbstractRetriever.class.getName());
    final MutableCatalog catalog;
    private final SchemaCrawlerOptions options;
    private final RetrieverConnection retrieverConnection;

    AbstractRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        this.retrieverConnection = Objects.requireNonNull(retrieverConnection, "No retriever connection provided");
        this.catalog = catalog;
        this.options = Objects.requireNonNull(options, "No SchemaCrawler options provided");
    }

    final boolean belongsToSchema(DatabaseObject dbObject, String catalogName, String schemaName) {
        if (dbObject == null) {
            return false;
        }
        boolean supportsCatalogs = this.retrieverConnection.isSupportsCatalogs();
        boolean belongsToCatalog = true;
        boolean belongsToSchema = true;
        if (supportsCatalogs) {
            String dbObjectCatalogName = dbObject.getSchema().getCatalogName();
            if (catalogName != null && !catalogName.equals(dbObjectCatalogName)) {
                belongsToCatalog = false;
            }
        }
        String dbObjectSchemaName = dbObject.getSchema().getName();
        if (schemaName != null && !schemaName.equals(dbObjectSchemaName)) {
            belongsToSchema = false;
        }
        return belongsToCatalog && belongsToSchema;
    }

    final NamedObjectList<SchemaReference> getAllSchemas() {
        return this.catalog.getAllSchemas();
    }

    final Connection getDatabaseConnection() {
        return this.retrieverConnection.getConnection();
    }

    final DatabaseMetaData getMetaData() {
        return this.retrieverConnection.getMetaData();
    }

    final RetrieverConnection getRetrieverConnection() {
        return this.retrieverConnection;
    }

    final InclusionRule getSchemaInclusionRule() {
        return this.options.getSchemaInclusionRule();
    }

    final void logPossiblyUnsupportedSQLFeature(Supplier<String> message, SQLException e) {
        if ("HYC00".equalsIgnoreCase(e.getSQLState()) || "HY000".equalsIgnoreCase(e.getSQLState())) {
            this.logSQLFeatureNotSupported(message, e);
        } else {
            LOGGER.log(Level.WARNING, message, (Throwable)e);
        }
    }

    final void logSQLFeatureNotSupported(Supplier<String> message, Throwable e) {
        LOGGER.log(Level.WARNING, message);
        LOGGER.log(Level.FINE, message, e);
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, int javaSqlType, String databaseSpecificTypeName) {
        return this.lookupOrCreateColumnDataType(schema, javaSqlType, databaseSpecificTypeName, null);
    }

    final MutableColumnDataType lookupOrCreateColumnDataType(Schema schema, int javaSqlTypeInt, String databaseSpecificTypeName, String mappedClassName) {
        MutableColumnDataType columnDataType = this.catalog.lookupColumnDataType(schema, databaseSpecificTypeName).orElse(this.catalog.lookupSystemColumnDataType(databaseSpecificTypeName).orElse(null));
        if (columnDataType == null) {
            columnDataType = new MutableColumnDataType(schema, databaseSpecificTypeName);
            JavaSqlType javaSqlType = this.retrieverConnection.getJavaSqlTypes().valueOf(javaSqlTypeInt);
            columnDataType.setJavaSqlType(javaSqlType);
            if (Utility.isBlank(mappedClassName)) {
                TypeMap typeMap = this.retrieverConnection.getTypeMap();
                Object mappedClass = typeMap.containsKey(databaseSpecificTypeName) ? typeMap.get(databaseSpecificTypeName) : typeMap.get(javaSqlType.getName());
                columnDataType.setTypeMappedClass((Class<?>)mappedClass);
            } else {
                columnDataType.setTypeMappedClass(mappedClassName);
            }
            this.catalog.addColumnDataType(columnDataType);
        }
        return columnDataType;
    }

    final Optional<MutableRoutine> lookupRoutine(String catalogName, String schemaName, String routineName, String specificName) {
        return this.catalog.lookupRoutine(Arrays.asList(catalogName, schemaName, routineName, specificName));
    }

    final Optional<MutableTable> lookupTable(String catalogName, String schemaName, String tableName) {
        return this.catalog.lookupTable(Arrays.asList(catalogName, schemaName, tableName));
    }

    final String normalizeCatalogName(String name) {
        if (this.retrieverConnection.isSupportsCatalogs()) {
            return name;
        }
        return null;
    }

    final String normalizeSchemaName(String name) {
        if (this.retrieverConnection.isSupportsSchemas()) {
            return name;
        }
        return null;
    }
}

