/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SearchableType;
import schemacrawler.utility.Identifiers;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

final class MutableColumnDataType
extends AbstractDatabaseObject
implements ColumnDataType {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(SchemaCrawler.class.getName());
    private static final long serialVersionUID = 3688503281676530744L;
    private boolean autoIncrementable;
    private ColumnDataType baseType;
    private boolean caseSensitive;
    private String createParameters = "";
    private boolean fixedPrecisionScale;
    private transient String fullName;
    private JavaSqlType javaSqlType = JavaSqlType.UNKNOWN;
    private Class<?> javaSqlTypeMappedClass = Object.class;
    private String literalPrefix = "";
    private String literalSuffix = "";
    private String localizedTypeName = "";
    private int maximumScale;
    private int minimumScale;
    private boolean nullable;
    private int numPrecisionRadix;
    private long precision;
    private SearchableType searchable = SearchableType.unknown;
    private boolean unsigned;
    private boolean userDefined;
    private List<String> enumValues = new ArrayList<String>();

    MutableColumnDataType(ColumnDataType columnDataType) {
        this(columnDataType.getSchema(), columnDataType.getName());
        this.autoIncrementable = columnDataType.isAutoIncrementable();
        this.baseType = columnDataType.getBaseType();
        this.caseSensitive = columnDataType.isCaseSensitive();
        this.createParameters = columnDataType.getCreateParameters();
        this.fixedPrecisionScale = columnDataType.isFixedPrecisionScale();
        this.javaSqlType = columnDataType.getJavaSqlType();
        this.javaSqlTypeMappedClass = columnDataType.getTypeMappedClass();
        this.literalPrefix = columnDataType.getLiteralPrefix();
        this.literalSuffix = columnDataType.getLiteralSuffix();
        this.localizedTypeName = columnDataType.getLocalTypeName();
        this.maximumScale = columnDataType.getMaximumScale();
        this.minimumScale = columnDataType.getMinimumScale();
        this.nullable = columnDataType.isNullable();
        this.numPrecisionRadix = columnDataType.getNumPrecisionRadix();
        this.precision = columnDataType.getPrecision();
        this.searchable = columnDataType.getSearchable();
        this.unsigned = columnDataType.isUnsigned();
        this.userDefined = columnDataType.isUserDefined();
        this.enumValues = new ArrayList<String>(columnDataType.getEnumValues());
    }

    MutableColumnDataType(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public ColumnDataType getBaseType() {
        return this.baseType;
    }

    void setBaseType(ColumnDataType baseType) {
        this.baseType = baseType;
    }

    @Override
    public String getCreateParameters() {
        return this.createParameters;
    }

    void setCreateParameters(String createParams) {
        this.createParameters = createParams;
    }

    @Override
    public String getDatabaseSpecificTypeName() {
        return this.getName();
    }

    @Override
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues == null ? new ArrayList<String>() : enumValues;
    }

    @Override
    public boolean isEnumerated() {
        return !this.enumValues.isEmpty();
    }

    @Override
    public JavaSqlType getJavaSqlType() {
        return this.javaSqlType;
    }

    void setJavaSqlType(JavaSqlType javaSqlType) {
        this.javaSqlType = javaSqlType != null ? javaSqlType : JavaSqlType.UNKNOWN;
    }

    @Override
    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    void setLiteralPrefix(String literalPrefix) {
        this.literalPrefix = literalPrefix;
    }

    @Override
    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    void setLiteralSuffix(String literalSuffix) {
        this.literalSuffix = literalSuffix;
    }

    @Override
    public String getLocalTypeName() {
        return this.localizedTypeName;
    }

    void setLocalTypeName(String localTypeName) {
        this.localizedTypeName = localTypeName;
    }

    @Override
    public int getMaximumScale() {
        return this.maximumScale;
    }

    void setMaximumScale(int maximumScale) {
        this.maximumScale = maximumScale;
    }

    @Override
    public int getMinimumScale() {
        return this.minimumScale;
    }

    void setMinimumScale(int minimumScale) {
        this.minimumScale = minimumScale;
    }

    @Override
    public int getNumPrecisionRadix() {
        return this.numPrecisionRadix;
    }

    void setNumPrecisionRadix(int numPrecisionRadix) {
        this.numPrecisionRadix = numPrecisionRadix;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    void setPrecision(long precision) {
        this.precision = precision;
    }

    @Override
    public SearchableType getSearchable() {
        return this.searchable;
    }

    void setSearchable(SearchableType searchable) {
        this.searchable = searchable;
    }

    @Override
    public Class<?> getTypeMappedClass() {
        return this.javaSqlTypeMappedClass;
    }

    void setTypeMappedClass(Class<?> mappedClass) {
        this.javaSqlTypeMappedClass = mappedClass != null ? mappedClass : Object.class;
    }

    void setTypeMappedClass(String mappedClassName) {
        if (!Utility.isBlank(mappedClassName)) {
            try {
                this.javaSqlTypeMappedClass = Class.forName(mappedClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINE, new StringFormat("Could not load mapped class <%s>", mappedClassName), (Throwable)e);
                this.javaSqlTypeMappedClass = Object.class;
            }
        } else {
            this.javaSqlTypeMappedClass = Object.class;
        }
    }

    @Override
    public boolean isAutoIncrementable() {
        return this.autoIncrementable;
    }

    void setAutoIncrementable(boolean autoIncrementable) {
        this.autoIncrementable = autoIncrementable;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean isFixedPrecisionScale() {
        return this.fixedPrecisionScale;
    }

    void setFixedPrecisionScale(boolean fixedPrecisionScale) {
        this.fixedPrecisionScale = fixedPrecisionScale;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    void setUnsigned(boolean unsignedAttribute) {
        this.unsigned = unsignedAttribute;
    }

    @Override
    public boolean isUserDefined() {
        return this.userDefined;
    }

    void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    private void buildFullName() {
        if (this.fullName != null) {
            return;
        }
        Schema schema = this.getSchema();
        if (!Utility.isBlank(schema.getFullName())) {
            Identifiers identifiers = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
            this.fullName = identifiers.quoteFullName(this);
        } else {
            this.fullName = this.getName();
        }
    }
}

