/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import schemacrawler.crawl.ImmutableDatabaseProperty;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseProperty;
import schemacrawler.schema.Property;

final class MutableDatabaseInfo
implements DatabaseInfo {
    private static final long serialVersionUID = 4051323422934251828L;
    private final Set<DatabaseProperty> databaseProperties = new HashSet<DatabaseProperty>();
    private final Set<Property> serverInfo = new HashSet<Property>();
    private String productName = "";
    private String productVersion = "";
    private String userName = "";

    MutableDatabaseInfo() {
    }

    @Override
    public String getProductName() {
        return this.productName;
    }

    void setProductName(String productName) {
        this.productName = productName;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    @Override
    public Collection<DatabaseProperty> getProperties() {
        ArrayList<DatabaseProperty> properties = new ArrayList<DatabaseProperty>(this.databaseProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public Collection<Property> getServerInfo() {
        return new TreeSet<Property>(this.serverInfo);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- database: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        return info.toString();
    }

    void addAll(Collection<ImmutableDatabaseProperty> dbProperties) {
        if (dbProperties != null) {
            this.databaseProperties.addAll(dbProperties);
        }
    }

    void addServerInfo(Property property) {
        if (property != null) {
            this.serverInfo.add(property);
        }
    }
}

