/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.function.Predicate;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schemacrawler.IncludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

final class DatabaseObjectFilter<D extends DatabaseObject>
implements Predicate<D> {
    private final InclusionRule databaseObjectInclusionRule;
    private final InclusionRule schemaInclusionRule;

    DatabaseObjectFilter(SchemaCrawlerOptions options, InclusionRule databaseObjectInclusionRule) {
        this.schemaInclusionRule = options != null ? options.getSchemaInclusionRule() : new IncludeAll();
        this.databaseObjectInclusionRule = databaseObjectInclusionRule != null ? databaseObjectInclusionRule : new IncludeAll();
    }

    @Override
    public boolean test(D databaseObject) {
        if (databaseObject == null) {
            return false;
        }
        boolean include = true;
        if (include && this.schemaInclusionRule != null) {
            include = this.schemaInclusionRule.test(databaseObject.getSchema().getFullName());
        }
        if (include && this.databaseObjectInclusionRule != null) {
            include = this.databaseObjectInclusionRule.test(databaseObject.getFullName());
        }
        return include;
    }
}

