/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;

public class TableTypesFilter
implements Predicate<Table> {
    private final Collection<String> tableTypes;

    public TableTypesFilter() {
        this.tableTypes = null;
    }

    public TableTypesFilter(SchemaCrawlerOptions options) {
        if (options != null) {
            Collection<String> tableTypesOptions = options.getTableTypes();
            if (tableTypesOptions == null) {
                this.tableTypes = null;
            } else {
                this.tableTypes = new HashSet<String>();
                for (String tableType : tableTypesOptions) {
                    this.tableTypes.add(tableType.toLowerCase());
                }
            }
        } else {
            this.tableTypes = null;
        }
    }

    public TableTypesFilter(String ... tableTypesFiltered) {
        if (tableTypesFiltered != null) {
            String[] tableTypesOptions = tableTypesFiltered;
            this.tableTypes = new HashSet<String>();
            for (String tableType : tableTypesOptions) {
                this.tableTypes.add(tableType.toLowerCase());
            }
        } else {
            this.tableTypes = null;
        }
    }

    @Override
    public boolean test(Table table) {
        boolean include = this.tableTypes != null ? this.tableTypes.contains(table.getTableType().getTableType().toLowerCase()) : true;
        return include;
    }
}

