/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.Collection;
import java.util.Optional;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DescribedObject;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;

public interface Catalog
extends NamedObject,
AttributedObject,
DescribedObject {
    public Collection<ColumnDataType> getColumnDataTypes();

    public Collection<ColumnDataType> getColumnDataTypes(Schema var1);

    public CrawlInfo getCrawlInfo();

    public DatabaseInfo getDatabaseInfo();

    public JdbcDriverInfo getJdbcDriverInfo();

    public Collection<Routine> getRoutines();

    public Collection<Routine> getRoutines(Schema var1);

    public Collection<Schema> getSchemas();

    public Collection<Sequence> getSequences();

    public Collection<Sequence> getSequences(Schema var1);

    public Collection<Synonym> getSynonyms();

    public Collection<Synonym> getSynonyms(Schema var1);

    public Collection<ColumnDataType> getSystemColumnDataTypes();

    public Collection<Table> getTables();

    public Collection<Table> getTables(Schema var1);

    public <C extends ColumnDataType> Optional<C> lookupColumnDataType(Schema var1, String var2);

    public <R extends Routine> Optional<R> lookupRoutine(Schema var1, String var2);

    public <S extends Schema> Optional<S> lookupSchema(String var1);

    public <S extends Sequence> Optional<S> lookupSequence(Schema var1, String var2);

    public <S extends Synonym> Optional<S> lookupSynonym(Schema var1, String var2);

    public <C extends ColumnDataType> Optional<C> lookupSystemColumnDataType(String var1);

    public <T extends Table> Optional<T> lookupTable(Schema var1, String var2);
}

