/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.io.Serializable;
import sf.util.Utility;

public final class TableType
implements Serializable,
Comparable<TableType> {
    public static final TableType UNKNOWN = new TableType("unknown");
    private static final long serialVersionUID = -8172248482959041873L;
    private final String tableType;

    public TableType(String tableTypeString) {
        if (Utility.isBlank(tableTypeString)) {
            throw new IllegalArgumentException("No table type provided");
        }
        this.tableType = tableTypeString.trim();
    }

    @Override
    public int compareTo(TableType other) {
        String otherToString;
        if (other == null) {
            return 1;
        }
        String thisToString = this.toString();
        if (thisToString.equalsIgnoreCase(otherToString = other.toString())) {
            return 0;
        }
        boolean isThisTable = "TABLE".equalsIgnoreCase(thisToString);
        boolean isOtherTable = "TABLE".equalsIgnoreCase(otherToString);
        if (isThisTable && !isOtherTable) {
            return -1;
        }
        if (!isThisTable && isOtherTable) {
            return 1;
        }
        boolean isThisView = "VIEW".equalsIgnoreCase(thisToString);
        boolean isOtherView = "VIEW".equalsIgnoreCase(otherToString);
        if (isThisView && !isOtherView) {
            return -1;
        }
        if (!isThisView && isOtherView) {
            return 1;
        }
        return thisToString.compareTo(otherToString);
    }

    public String getTableType() {
        return this.tableType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableType == null ? 0 : this.tableType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableType)) {
            return false;
        }
        TableType other = (TableType)obj;
        if (this.tableType == null) {
            return other.tableType == null;
        }
        return this.tableType.equalsIgnoreCase(other.tableType);
    }

    public String toString() {
        return this.tableType == null ? "" : this.tableType.toLowerCase();
    }

    public boolean isEqualTo(String testTableType) {
        if (Utility.isBlank(testTableType)) {
            return false;
        }
        return this.tableType.equalsIgnoreCase(testTableType.trim());
    }

    public boolean isView() {
        return this.tableType != null && (this.tableType.toUpperCase().contains("VIEW") || this.tableType.toUpperCase().contains("MATERIALIZED"));
    }
}

