/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.io.Serializable;
import sf.util.Utility;

public final class DatabaseServerType
implements Serializable,
Comparable<DatabaseServerType> {
    public static final DatabaseServerType UNKNOWN = new DatabaseServerType();
    private static final long serialVersionUID = 2160456864554076419L;
    private final String databaseSystemIdentifier;
    private final String databaseSystemName;

    public DatabaseServerType(String databaseSystemIdentifier, String databaseSystemName) {
        if (Utility.isBlank(databaseSystemIdentifier)) {
            throw new IllegalArgumentException("No database system identifier provided");
        }
        this.databaseSystemIdentifier = databaseSystemIdentifier;
        if (Utility.isBlank(databaseSystemName)) {
            throw new IllegalArgumentException("No database system name provided");
        }
        this.databaseSystemName = databaseSystemName;
    }

    private DatabaseServerType() {
        this.databaseSystemIdentifier = null;
        this.databaseSystemName = null;
    }

    @Override
    public int compareTo(DatabaseServerType other) {
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return -1;
        }
        if (other.isUnknownDatabaseSystem() && !this.isUnknownDatabaseSystem()) {
            return 1;
        }
        if (!other.isUnknownDatabaseSystem() && this.isUnknownDatabaseSystem()) {
            return -1;
        }
        return this.getDatabaseSystemIdentifier().compareTo(other.getDatabaseSystemIdentifier());
    }

    public String getDatabaseSystemIdentifier() {
        return this.databaseSystemIdentifier;
    }

    public String getDatabaseSystemName() {
        return this.databaseSystemName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.databaseSystemIdentifier == null ? 0 : this.databaseSystemIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseServerType other = (DatabaseServerType)obj;
        if (this.databaseSystemIdentifier == null) {
            return other.databaseSystemIdentifier == null;
        }
        return this.databaseSystemIdentifier.equals(other.databaseSystemIdentifier);
    }

    public String toString() {
        if (this.isUnknownDatabaseSystem()) {
            return "";
        }
        return String.format("%s - %s", this.databaseSystemIdentifier, this.databaseSystemName);
    }

    public boolean isUnknownDatabaseSystem() {
        return Utility.isBlank(this.databaseSystemIdentifier);
    }
}

