/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.OptionsBuilder;
import sf.util.IOUtility;
import sf.util.ObjectToString;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class InformationSchemaViewsBuilder
implements OptionsBuilder<InformationSchemaViewsBuilder, InformationSchemaViews> {
    private final Map<InformationSchemaKey, String> informationSchemaQueries = new EnumMap<InformationSchemaKey, String>(InformationSchemaKey.class);

    public static InformationSchemaViewsBuilder builder() {
        return new InformationSchemaViewsBuilder();
    }

    public static InformationSchemaViewsBuilder builder(InformationSchemaViews informationSchemaViews) {
        return new InformationSchemaViewsBuilder().fromOptions(informationSchemaViews);
    }

    public static InformationSchemaViews newInformationSchemaViews() {
        return new InformationSchemaViewsBuilder().toOptions();
    }

    public static InformationSchemaViews newInformationSchemaViews(Config config) {
        return new InformationSchemaViewsBuilder().fromConfig(config).toOptions();
    }

    private InformationSchemaViewsBuilder() {
    }

    public InformationSchemaViewsBuilder fromConfig(Config informationSchemaViewsSql) {
        if (informationSchemaViewsSql == null) {
            return this;
        }
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            if (!informationSchemaViewsSql.containsKey(key.getLookupKey())) continue;
            try {
                this.informationSchemaQueries.put(key, informationSchemaViewsSql.get(key.getLookupKey()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    public InformationSchemaViewsBuilder fromOptions(InformationSchemaViews informationSchemaViews) {
        if (informationSchemaViews == null) {
            return this;
        }
        this.informationSchemaQueries.putAll(informationSchemaViews.getInformationSchemaQueries());
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InformationSchemaViews toOptions() {
        return new InformationSchemaViews(this.informationSchemaQueries);
    }

    public InformationSchemaViewsBuilder fromResourceFolder(String classpath) {
        if (Utility.isBlank(classpath)) {
            return this;
        }
        for (InformationSchemaKey key : InformationSchemaKey.values()) {
            String resource = classpath == null ? key.getResource() : String.format("%s/%s", classpath, key.getResource());
            String sql = IOUtility.readResourceFully(resource);
            if (Utility.isBlank(sql)) continue;
            this.informationSchemaQueries.put(key, sql);
        }
        return this;
    }

    public void substituteAll(String templateKey, String templateValue) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(templateKey, templateValue);
        for (Map.Entry<InformationSchemaKey, String> query : this.informationSchemaQueries.entrySet()) {
            String sql = query.getValue();
            sql = TemplatingUtility.expandTemplate(sql, map);
            query.setValue(sql);
        }
    }

    public String toString() {
        return ObjectToString.toString(this.informationSchemaQueries);
    }

    public InformationSchemaViewsBuilder withSql(InformationSchemaKey key, String sql) {
        Objects.requireNonNull(key, "No key provided");
        if (Utility.isBlank(sql)) {
            this.informationSchemaQueries.remove((Object)key);
        } else {
            this.informationSchemaQueries.put(key, sql);
        }
        return this;
    }
}

