/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaInfoLevel;
import sf.util.ObjectToString;

public final class SchemaCrawlerOptions
implements Options {
    private final int childTableFilterDepth;
    private final InclusionRule columnInclusionRule;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;
    private final boolean grepInvertMatch;
    private final boolean grepOnlyMatching;
    private final InclusionRule grepRoutineParameterInclusionRule;
    private final boolean isNoEmptyTables;
    private final boolean isLoadRowCounts;
    private final int parentTableFilterDepth;
    private final InclusionRule routineInclusionRule;
    private final InclusionRule routineParameterInclusionRule;
    private final Collection<RoutineType> routineTypes;
    private final InclusionRule schemaInclusionRule;
    private final SchemaInfoLevel schemaInfoLevel;
    private final InclusionRule sequenceInclusionRule;
    private final InclusionRule synonymInclusionRule;
    private final InclusionRule tableInclusionRule;
    private final String tableNamePattern;
    private final Collection<String> tableTypes;

    SchemaCrawlerOptions(SchemaInfoLevel schemaInfoLevel, InclusionRule schemaInclusionRule, InclusionRule synonymInclusionRule, InclusionRule sequenceInclusionRule, Collection<String> tableTypes, String tableNamePattern, InclusionRule tableInclusionRule, InclusionRule columnInclusionRule, Collection<RoutineType> routineTypes, InclusionRule routineInclusionRule, InclusionRule routineParameterInclusionRule, InclusionRule grepColumnInclusionRule, InclusionRule grepRoutineParameterInclusionRule, InclusionRule grepDefinitionInclusionRule, boolean grepInvertMatch, boolean grepOnlyMatching, boolean isNoEmptyTables, boolean isLoadRowCounts, int childTableFilterDepth, int parentTableFilterDepth) {
        this.schemaInfoLevel = schemaInfoLevel;
        this.schemaInclusionRule = schemaInclusionRule;
        this.synonymInclusionRule = synonymInclusionRule;
        this.sequenceInclusionRule = sequenceInclusionRule;
        this.tableTypes = tableTypes;
        this.tableNamePattern = tableNamePattern;
        this.tableInclusionRule = tableInclusionRule;
        this.columnInclusionRule = columnInclusionRule;
        this.routineTypes = routineTypes;
        this.routineInclusionRule = routineInclusionRule;
        this.routineParameterInclusionRule = routineParameterInclusionRule;
        this.grepColumnInclusionRule = grepColumnInclusionRule;
        this.grepRoutineParameterInclusionRule = grepRoutineParameterInclusionRule;
        this.grepDefinitionInclusionRule = grepDefinitionInclusionRule;
        this.grepInvertMatch = grepInvertMatch;
        this.grepOnlyMatching = grepOnlyMatching;
        this.isNoEmptyTables = isNoEmptyTables;
        this.isLoadRowCounts = isLoadRowCounts;
        this.childTableFilterDepth = childTableFilterDepth;
        this.parentTableFilterDepth = parentTableFilterDepth;
    }

    public int getChildTableFilterDepth() {
        return this.childTableFilterDepth;
    }

    public InclusionRule getColumnInclusionRule() {
        return this.columnInclusionRule;
    }

    public Optional<InclusionRule> getGrepColumnInclusionRule() {
        return Optional.ofNullable(this.grepColumnInclusionRule);
    }

    public Optional<InclusionRule> getGrepDefinitionInclusionRule() {
        return Optional.ofNullable(this.grepDefinitionInclusionRule);
    }

    public Optional<InclusionRule> getGrepRoutineParameterInclusionRule() {
        return Optional.ofNullable(this.grepRoutineParameterInclusionRule);
    }

    public int getParentTableFilterDepth() {
        return this.parentTableFilterDepth;
    }

    public InclusionRule getRoutineParameterInclusionRule() {
        return this.routineParameterInclusionRule;
    }

    public InclusionRule getRoutineInclusionRule() {
        return this.routineInclusionRule;
    }

    public Collection<RoutineType> getRoutineTypes() {
        if (this.routineTypes == null) {
            return null;
        }
        return new HashSet<RoutineType>(this.routineTypes);
    }

    public InclusionRule getSchemaInclusionRule() {
        return this.schemaInclusionRule;
    }

    public SchemaInfoLevel getSchemaInfoLevel() {
        return this.schemaInfoLevel;
    }

    public InclusionRule getSequenceInclusionRule() {
        return this.sequenceInclusionRule;
    }

    public InclusionRule getSynonymInclusionRule() {
        return this.synonymInclusionRule;
    }

    public InclusionRule getTableInclusionRule() {
        return this.tableInclusionRule;
    }

    public String getTableNamePattern() {
        return this.tableNamePattern;
    }

    public Collection<String> getTableTypes() {
        if (this.tableTypes == null) {
            return null;
        }
        return new HashSet<String>(this.tableTypes);
    }

    public boolean isGrepColumns() {
        return this.grepColumnInclusionRule != null;
    }

    public boolean isGrepDefinitions() {
        return this.grepDefinitionInclusionRule != null;
    }

    public boolean isGrepInvertMatch() {
        return this.grepInvertMatch;
    }

    public boolean isGrepOnlyMatching() {
        return this.grepOnlyMatching;
    }

    public boolean isGrepRoutineParameters() {
        return this.grepRoutineParameterInclusionRule != null;
    }

    public boolean isNoEmptyTables() {
        return this.isNoEmptyTables;
    }

    public boolean isLoadRowCounts() {
        return this.isLoadRowCounts;
    }

    public String toString() {
        return ObjectToString.toString(this);
    }
}

