/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import schemacrawler.crawl.MetadataRetrievalStrategy;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.utility.Identifiers;
import schemacrawler.utility.TypeMap;
import sf.util.Utility;

public final class SchemaRetrievalOptionsBuilder
implements OptionsBuilder<SchemaRetrievalOptionsBuilder, SchemaRetrievalOptions> {
    private static final String prefix = "schemacrawler.schema.retrieval.strategy";
    private static final String SC_RETRIEVAL_TABLES = "schemacrawler.schema.retrieval.strategy.tables";
    private static final String SC_RETRIEVAL_TABLE_COLUMNS = "schemacrawler.schema.retrieval.strategy.tablecolumns";
    private static final String SC_RETRIEVAL_PRIMARY_KEYS = "schemacrawler.schema.retrieval.strategy.primarykeys";
    private static final String SC_RETRIEVAL_INDEXES = "schemacrawler.schema.retrieval.strategy.indexes";
    private static final String SC_RETRIEVAL_FOREIGN_KEYS = "schemacrawler.schema.retrieval.strategy.foreignkeys";
    private static final String SC_RETRIEVAL_PROCEDURES = "schemacrawler.schema.retrieval.strategy.procedures";
    private static final String SC_RETRIEVAL_PROCEDURE_COLUMNS = "schemacrawler.schema.retrieval.strategy.procedurecolumns";
    private static final String SC_RETRIEVAL_FUNCTIONS = "schemacrawler.schema.retrieval.strategy.functions";
    private static final String SC_RETRIEVAL_FUNCTION_COLUMNS = "schemacrawler.schema.retrieval.strategy.functioncolumns";
    private DatabaseServerType dbServerType = DatabaseServerType.UNKNOWN;
    private MetadataRetrievalStrategy fkRetrievalStrategy;
    private MetadataRetrievalStrategy functionColumnRetrievalStrategy;
    private MetadataRetrievalStrategy functionRetrievalStrategy;
    private String identifierQuoteString = "";
    private Identifiers identifiers;
    private MetadataRetrievalStrategy indexRetrievalStrategy;
    private InformationSchemaViewsBuilder informationSchemaViewsBuilder = InformationSchemaViewsBuilder.builder();
    private Optional<Boolean> overridesSupportSchemas = Optional.empty();
    private Optional<Boolean> overridesSupportsCatalogs = Optional.empty();
    private Optional<TypeMap> overridesTypeMap;
    private MetadataRetrievalStrategy pkRetrievalStrategy;
    private MetadataRetrievalStrategy procedureColumnRetrievalStrategy;
    private MetadataRetrievalStrategy procedureRetrievalStrategy;
    private boolean supportsCatalogs = true;
    private boolean supportsSchemas = true;
    private MetadataRetrievalStrategy tableColumnRetrievalStrategy;
    private MetadataRetrievalStrategy tableRetrievalStrategy;
    private EnumDataTypeHelper enumDataTypeHelper;

    public static SchemaRetrievalOptionsBuilder builder() {
        return new SchemaRetrievalOptionsBuilder();
    }

    public static SchemaRetrievalOptionsBuilder builder(SchemaRetrievalOptions options) {
        return new SchemaRetrievalOptionsBuilder().fromOptions(options);
    }

    public static SchemaRetrievalOptions newSchemaRetrievalOptions() {
        return new SchemaRetrievalOptionsBuilder().toOptions();
    }

    public static SchemaRetrievalOptions newSchemaRetrievalOptions(Config config) {
        return new SchemaRetrievalOptionsBuilder().fromConfig(config).toOptions();
    }

    private SchemaRetrievalOptionsBuilder() {
        this.identifiers = Identifiers.STANDARD;
        this.tableRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.tableColumnRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.pkRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.indexRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.fkRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.procedureRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.procedureColumnRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.functionRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.functionColumnRetrievalStrategy = MetadataRetrievalStrategy.metadata;
        this.overridesTypeMap = Optional.empty();
        this.enumDataTypeHelper = EnumDataTypeHelper.NO_OP_ENUM_DATA_TYPE_HELPER;
    }

    public SchemaRetrievalOptionsBuilder fromConfig(Config config) {
        Config configProperties = config == null ? new Config() : new Config(config);
        this.informationSchemaViewsBuilder.fromConfig(configProperties);
        this.tableRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_TABLES, this.tableRetrievalStrategy);
        this.tableColumnRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_TABLE_COLUMNS, this.tableColumnRetrievalStrategy);
        this.pkRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_PRIMARY_KEYS, this.pkRetrievalStrategy);
        this.indexRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_INDEXES, this.indexRetrievalStrategy);
        this.fkRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_FOREIGN_KEYS, this.fkRetrievalStrategy);
        this.procedureRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_PROCEDURES, this.procedureRetrievalStrategy);
        this.procedureColumnRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_PROCEDURE_COLUMNS, this.procedureColumnRetrievalStrategy);
        this.functionRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_FUNCTIONS, this.functionRetrievalStrategy);
        this.functionColumnRetrievalStrategy = configProperties.getEnumValue(SC_RETRIEVAL_FUNCTION_COLUMNS, this.functionColumnRetrievalStrategy);
        return this;
    }

    public SchemaRetrievalOptionsBuilder fromOptions(SchemaRetrievalOptions options) {
        if (options == null) {
            return this;
        }
        this.dbServerType = options.getDatabaseServerType();
        this.informationSchemaViewsBuilder = InformationSchemaViewsBuilder.builder(options.getInformationSchemaViews());
        this.overridesSupportSchemas = Optional.empty();
        this.overridesSupportsCatalogs = Optional.empty();
        this.supportsCatalogs = options.isSupportsCatalogs();
        this.supportsSchemas = options.isSupportsSchemas();
        this.identifierQuoteString = options.getIdentifierQuoteString();
        this.identifiers = options.getIdentifiers();
        this.tableRetrievalStrategy = options.getTableRetrievalStrategy();
        this.tableColumnRetrievalStrategy = options.getTableColumnRetrievalStrategy();
        this.pkRetrievalStrategy = options.getPrimaryKeyRetrievalStrategy();
        this.indexRetrievalStrategy = options.getIndexRetrievalStrategy();
        this.fkRetrievalStrategy = options.getForeignKeyRetrievalStrategy();
        this.procedureRetrievalStrategy = options.getProcedureRetrievalStrategy();
        this.procedureColumnRetrievalStrategy = options.getProcedureColumnRetrievalStrategy();
        this.functionRetrievalStrategy = options.getFunctionRetrievalStrategy();
        this.functionColumnRetrievalStrategy = options.getFunctionColumnRetrievalStrategy();
        this.overridesTypeMap = Optional.empty();
        return this;
    }

    @Override
    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaRetrievalOptions toOptions() {
        return new SchemaRetrievalOptions(this);
    }

    public SchemaRetrievalOptionsBuilder fromConnnection(Connection connection) {
        DatabaseMetaData metaData;
        if (connection == null) {
            return this;
        }
        try {
            metaData = connection.getMetaData();
        }
        catch (SQLException e) {
            metaData = null;
        }
        this.identifierQuoteString = this.lookupIdentifierQuoteString(metaData);
        this.identifiers = Identifiers.identifiers().withConnectionIfPossible(connection).withIdentifierQuoteString(this.identifierQuoteString).build();
        this.supportsCatalogs = this.lookupSupportsCatalogs(metaData);
        this.supportsSchemas = this.lookupSupportsSchemas(metaData);
        if (!this.overridesTypeMap.isPresent()) {
            this.overridesTypeMap = Optional.of(new TypeMap(connection));
        }
        return this;
    }

    public DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public MetadataRetrievalStrategy getForeignKeyRetrievalStrategy() {
        return this.fkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getFunctionColumnRetrievalStrategy() {
        return this.functionColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getFunctionRetrievalStrategy() {
        return this.functionRetrievalStrategy;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public Identifiers getIdentifiers() {
        return this.identifiers;
    }

    public MetadataRetrievalStrategy getIndexRetrievalStrategy() {
        return this.indexRetrievalStrategy;
    }

    public InformationSchemaViews getInformationSchemaViews() {
        return this.informationSchemaViewsBuilder.toOptions();
    }

    public MetadataRetrievalStrategy getPrimaryKeyRetrievalStrategy() {
        return this.pkRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getProcedureColumnRetrievalStrategy() {
        return this.procedureColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getProcedureRetrievalStrategy() {
        return this.procedureRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableColumnRetrievalStrategy() {
        return this.tableColumnRetrievalStrategy;
    }

    public MetadataRetrievalStrategy getTableRetrievalStrategy() {
        return this.tableRetrievalStrategy;
    }

    public TypeMap getTypeMap() {
        return this.overridesTypeMap.orElse(new TypeMap());
    }

    public boolean isSupportsCatalogs() {
        return this.supportsCatalogs;
    }

    public boolean isSupportsSchemas() {
        return this.supportsSchemas;
    }

    public SchemaRetrievalOptionsBuilder withDatabaseServerType(DatabaseServerType dbServerType) {
        this.dbServerType = dbServerType == null ? DatabaseServerType.UNKNOWN : dbServerType;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withDoesNotSupportCatalogs() {
        this.overridesSupportsCatalogs = Optional.of(false);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withDoesNotSupportSchemas() {
        this.overridesSupportSchemas = Optional.of(false);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withForeignKeyRetrievalStrategy(MetadataRetrievalStrategy fkRetrievalStrategy) {
        this.fkRetrievalStrategy = fkRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : fkRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withFunctionColumnRetrievalStrategy(MetadataRetrievalStrategy functionColumnRetrievalStrategy) {
        this.functionColumnRetrievalStrategy = functionColumnRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : functionColumnRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withFunctionRetrievalStrategy(MetadataRetrievalStrategy functionRetrievalStrategy) {
        this.functionRetrievalStrategy = functionRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : functionRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withIdentifierQuoteString(String identifierQuoteString) {
        this.identifierQuoteString = Utility.isBlank(identifierQuoteString) ? "" : identifierQuoteString;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withIndexRetrievalStrategy(MetadataRetrievalStrategy indexRetrievalStrategy) {
        this.indexRetrievalStrategy = indexRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : indexRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withInformationSchemaViews(Map<String, String> informationSchemaViews) {
        this.informationSchemaViewsBuilder.fromConfig(new Config(informationSchemaViews));
        return this;
    }

    public InformationSchemaViewsBuilder withInformationSchemaViewsBuilder() {
        return this.informationSchemaViewsBuilder;
    }

    public SchemaRetrievalOptionsBuilder withInformationSchemaViewsForConnection(BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuilderForConnection, Connection connection) {
        if (informationSchemaViewsBuilderForConnection != null) {
            informationSchemaViewsBuilderForConnection.accept(this.informationSchemaViewsBuilder, connection);
        }
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutIdentifierQuoteString() {
        this.identifierQuoteString = "";
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutSupportsCatalogs() {
        this.overridesSupportsCatalogs = Optional.empty();
        return this;
    }

    public SchemaRetrievalOptionsBuilder withoutSupportsSchemas() {
        this.overridesSupportSchemas = Optional.empty();
        return this;
    }

    public SchemaRetrievalOptionsBuilder withPrimaryKeyRetrievalStrategy(MetadataRetrievalStrategy pkRetrievalStrategy) {
        this.pkRetrievalStrategy = pkRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : pkRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withProcedureColumnRetrievalStrategy(MetadataRetrievalStrategy procedureColumnRetrievalStrategy) {
        this.procedureColumnRetrievalStrategy = procedureColumnRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : procedureColumnRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withProcedureRetrievalStrategy(MetadataRetrievalStrategy procedureRetrievalStrategy) {
        this.procedureRetrievalStrategy = procedureRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : procedureRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withSupportsCatalogs() {
        this.overridesSupportsCatalogs = Optional.of(true);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withSupportsSchemas() {
        this.overridesSupportSchemas = Optional.of(true);
        return this;
    }

    public SchemaRetrievalOptionsBuilder withTableColumnRetrievalStrategy(MetadataRetrievalStrategy tableColumnRetrievalStrategy) {
        this.tableColumnRetrievalStrategy = tableColumnRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : tableColumnRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withTableRetrievalStrategy(MetadataRetrievalStrategy tableRetrievalStrategy) {
        this.tableRetrievalStrategy = tableRetrievalStrategy == null ? MetadataRetrievalStrategy.metadata : tableRetrievalStrategy;
        return this;
    }

    public SchemaRetrievalOptionsBuilder withTypeMap(Map<String, Class<?>> typeMap) {
        this.overridesTypeMap = typeMap == null ? Optional.empty() : Optional.of(new TypeMap(typeMap));
        return this;
    }

    public SchemaRetrievalOptionsBuilder withEnumDataTypeHelper(EnumDataTypeHelper enumDataTypeHelper) {
        this.enumDataTypeHelper = enumDataTypeHelper != null ? enumDataTypeHelper : EnumDataTypeHelper.NO_OP_ENUM_DATA_TYPE_HELPER;
        return this;
    }

    public EnumDataTypeHelper getEnumDataTypeHelper() {
        return this.enumDataTypeHelper;
    }

    private String lookupIdentifierQuoteString(DatabaseMetaData metaData) {
        String identifierQuoteString = "\"";
        if (!Utility.isBlank(this.identifierQuoteString)) {
            identifierQuoteString = this.identifierQuoteString;
        } else if (metaData != null) {
            try {
                identifierQuoteString = metaData.getIdentifierQuoteString();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (Utility.isBlank(identifierQuoteString)) {
            identifierQuoteString = "";
        }
        return identifierQuoteString;
    }

    private boolean lookupSupportsCatalogs(DatabaseMetaData metaData) {
        boolean supportsCatalogs = true;
        if (this.overridesSupportsCatalogs.isPresent()) {
            supportsCatalogs = this.overridesSupportsCatalogs.get();
        } else if (metaData != null) {
            try {
                supportsCatalogs = metaData.supportsCatalogsInTableDefinitions();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return supportsCatalogs;
    }

    private boolean lookupSupportsSchemas(DatabaseMetaData metaData) {
        boolean supportsSchemas = true;
        if (this.overridesSupportSchemas.isPresent()) {
            supportsSchemas = this.overridesSupportSchemas.get();
        } else if (metaData != null) {
            try {
                supportsSchemas = metaData.supportsSchemasInTableDefinitions();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return supportsSchemas;
    }
}

