/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseCommandChain;
import schemacrawler.tools.executable.Commands;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.text.base.CommonTextOptionsBuilder;

public final class CommandDaisyChain
extends BaseCommandChain {
    public CommandDaisyChain(String commands) throws SchemaCrawlerException {
        super(commands);
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        Commands commands = new Commands(this.getCommand());
        if (commands.isEmpty()) {
            throw new SchemaCrawlerException("No command specified");
        }
        for (String command : commands) {
            SchemaCrawlerCommand scCommand = this.addNextAndConfigureForExecution(command, this.outputOptions);
            if (scCommand == null) continue;
            CommonTextOptionsBuilder commonTextOptionsBuilder = (CommonTextOptionsBuilder)CommonTextOptionsBuilder.builder().fromConfig(this.additionalConfiguration);
            if (commands.hasMultipleCommands()) {
                if (commands.isFirstCommand(command)) {
                    commonTextOptionsBuilder.noFooter();
                } else if (commands.isLastCommand(command)) {
                    commonTextOptionsBuilder.noHeader();
                    commonTextOptionsBuilder.noInfo();
                    commonTextOptionsBuilder.appendOutput();
                } else {
                    commonTextOptionsBuilder.noHeader();
                    commonTextOptionsBuilder.noInfo();
                    commonTextOptionsBuilder.noFooter();
                    commonTextOptionsBuilder.appendOutput();
                }
            }
            Config commandAdditionalConfig = new Config();
            if (this.additionalConfiguration != null) {
                commandAdditionalConfig.putAll(this.additionalConfiguration);
            }
            commandAdditionalConfig.putAll(commonTextOptionsBuilder.toConfig());
            scCommand.setAdditionalConfiguration(commandAdditionalConfig);
        }
        this.initializeChain();
        this.checkAvailabilityChain();
        this.executeChain();
    }

    @Override
    public boolean usesConnection() {
        return false;
    }
}

