/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.diagram;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.integration.diagram.DiagramOptions;
import schemacrawler.tools.integration.diagram.DiagramOptionsBuilder;
import schemacrawler.tools.integration.diagram.DiagramOutputFormat;
import schemacrawler.tools.integration.diagram.GraphExecutor;
import schemacrawler.tools.integration.diagram.GraphNoOpExecutor;
import schemacrawler.tools.integration.diagram.GraphvizJavaExecutor;
import schemacrawler.tools.integration.diagram.GraphvizProcessExecutor;
import schemacrawler.tools.integration.diagram.GraphvizUtility;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import schemacrawler.utility.NamedObjectSort;
import sf.util.IOUtility;

public final class DiagramRenderer
extends BaseSchemaCrawlerCommand {
    private DiagramOptions diagramOptions;
    private DiagramOutputFormat diagramOutputFormat;

    public DiagramRenderer(String command) {
        super(command);
    }

    @Override
    public void checkAvailability() throws Exception {
        if (this.diagramOutputFormat == DiagramOutputFormat.scdot) {
            return;
        }
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizUtility.isGraphvizJavaAvailable(this.diagramOutputFormat)) {
            return;
        }
        throw new SchemaCrawlerException(String.format("Cannot generate diagram in %s output format", this.diagramOutputFormat));
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadDiagramOptions();
    }

    @Override
    public void execute() throws Exception {
        this.checkCatalog();
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).toOptions();
        Path dotFile = IOUtility.createTempFilePath("schemacrawler.", "dot");
        OutputOptions dotFileOutputOptions = this.diagramOutputFormat == DiagramOutputFormat.scdot ? this.outputOptions : OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(DiagramOutputFormat.scdot).withOutputFile(dotFile).toOptions();
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFileOutputOptions);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(this.catalog);
        traverser.setHandler(formatter);
        traverser.setTablesComparator(NamedObjectSort.getNamedObjectSort(this.diagramOptions.isAlphabeticalSortForTables()));
        traverser.setRoutinesComparator(NamedObjectSort.getNamedObjectSort(this.diagramOptions.isAlphabeticalSortForRoutines()));
        traverser.traverse();
        GraphExecutor graphExecutor = this.getGraphExecutor(dotFile);
        boolean successful = (Boolean)graphExecutor.call();
        if (!successful) {
            String message = IOUtility.readResourceFully("/dot.error.txt");
            throw new SchemaCrawlerRuntimeException(message);
        }
    }

    @Override
    public boolean usesConnection() {
        return false;
    }

    public final void setDiagramOptions(DiagramOptions diagramOptions) {
        this.diagramOptions = Objects.requireNonNull(diagramOptions, "No diagram options provided");
    }

    private GraphExecutor getGraphExecutor(Path dotFile) throws SchemaCrawlerException {
        GraphExecutor graphExecutor;
        Path outputFile = this.outputOptions.getOutputFile(this.outputOptions.getOutputFormatValue());
        this.outputOptions = OutputOptionsBuilder.builder(this.outputOptions).withOutputFormat(this.diagramOutputFormat).withOutputFormatValue(this.diagramOutputFormat.getFormat()).withOutputFile(outputFile).toOptions();
        if (this.diagramOutputFormat != DiagramOutputFormat.scdot) {
            List<String> graphvizOpts = this.diagramOptions.getGraphvizOpts();
            boolean graphExecutorAvailable = false;
            graphExecutor = new GraphvizProcessExecutor(dotFile, outputFile, this.diagramOutputFormat, graphvizOpts);
            graphExecutorAvailable = graphExecutor.canGenerate();
            if (!graphExecutorAvailable) {
                graphExecutor = new GraphvizJavaExecutor(dotFile, outputFile, this.diagramOutputFormat);
                graphExecutorAvailable = graphExecutor.canGenerate();
            }
            if (!graphExecutorAvailable) {
                String message = IOUtility.readResourceFully("/dot.error.txt");
                throw new SchemaCrawlerRuntimeException(message);
            }
        } else {
            graphExecutor = new GraphNoOpExecutor(this.diagramOutputFormat);
        }
        return graphExecutor;
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(OutputOptions outputOptions) throws SchemaCrawlerException {
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        String identifierQuoteString = this.identifiers.getIdentifierQuoteString();
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, this.diagramOptions, outputOptions, identifierQuoteString);
        return formatter;
    }

    private void loadDiagramOptions() {
        if (this.diagramOptions == null) {
            this.diagramOptions = DiagramOptionsBuilder.newDiagramOptions(this.additionalConfiguration);
        }
        this.diagramOutputFormat = DiagramOutputFormat.fromFormat(this.outputOptions.getOutputFormatValue());
    }
}

