/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.diagram;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizEngine;
import guru.nidi.graphviz.engine.GraphvizJdkEngine;
import guru.nidi.graphviz.engine.GraphvizV8Engine;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.integration.diagram.DiagramOutputFormat;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;

public final class GraphvizJavaExecutorUtility {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphvizJavaExecutorUtility.class.getName());

    public static void generateGraph(Path dotFile, Path outputFile, DiagramOutputFormat diagramOutputFormat) throws SchemaCrawlerException {
        Objects.requireNonNull(dotFile, "No DOT file provided");
        Objects.requireNonNull(outputFile, "No diagram output file provided");
        Objects.requireNonNull(diagramOutputFormat, "No diagram output format provided");
        try {
            String dotSource = IOUtility.readFully(new FileReader(dotFile.toFile()));
            dotSource = dotSource.replaceAll("\\R", " ");
            List<GraphvizEngine> engines = GraphvizJavaExecutorUtility.loadGraphvizEngines();
            Graphviz.useEngine(engines);
            Format format = GraphvizJavaExecutorUtility.map(diagramOutputFormat);
            Graphviz.fromString((String)dotSource).render(format).toFile(outputFile.toFile());
        }
        catch (Throwable e) {
            throw new SchemaCrawlerException("Cannot generate diagram from " + dotFile, e);
        }
    }

    private static List<GraphvizEngine> loadGraphvizEngines() {
        GraphvizV8Engine engine;
        ArrayList<GraphvizEngine> engines = new ArrayList<GraphvizEngine>();
        try {
            engine = new GraphvizV8Engine();
            engines.add((GraphvizEngine)engine);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.INFO, "Cannot load GraphvizV8Engine");
        }
        try {
            engine = new GraphvizJdkEngine();
            engines.add((GraphvizEngine)engine);
        }
        catch (NoClassDefFoundError e) {
            LOGGER.log(Level.INFO, "Cannot load GraphvizJdkEngine");
        }
        return engines;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new IllegalArgumentException("<format> <DOT file> <output file>");
        }
        DiagramOutputFormat diagramOutputFormat = DiagramOutputFormat.valueOf(args[0]);
        Path dotFile = Paths.get(args[1], new String[0]).normalize().toAbsolutePath();
        Path outputFile = Paths.get(args[2], new String[0]).normalize().toAbsolutePath();
        GraphvizJavaExecutorUtility.generateGraph(dotFile, outputFile, diagramOutputFormat);
    }

    private static Format map(DiagramOutputFormat diagramOutputFormat) {
        Format format;
        if (diagramOutputFormat == null) {
            return null;
        }
        switch (diagramOutputFormat) {
            case svg: {
                format = Format.SVG;
                break;
            }
            case png: {
                format = Format.PNG;
                break;
            }
            case ps: {
                format = Format.PS;
                break;
            }
            case xdot: {
                format = Format.XDOT;
                break;
            }
            case plain: {
                format = Format.PLAIN;
                break;
            }
            default: {
                format = null;
            }
        }
        return format;
    }

    private GraphvizJavaExecutorUtility() {
    }
}

