/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import java.util.regex.Pattern;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DependantObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.utility.IdentifierQuotingStrategy;
import sf.util.SchemaCrawlerLogger;
import sf.util.Utility;

public final class Identifiers {
    public static final Identifiers STANDARD = Identifiers.identifiers().withIdentifierQuoteString("\"").build();
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(Identifiers.class.getName());
    private static final Pattern isAllNumeric = Pattern.compile("^\\p{Nd}*$");
    private static final Pattern isIdentifier = Pattern.compile("^[\\p{Nd}\\p{L}\\p{M}_]*$");
    private final String identifierQuoteString;
    private final IdentifierQuotingStrategy identifierQuotingStrategy;
    private final Collection<String> reservedWords;

    public static Builder identifiers() {
        return new Builder();
    }

    private static boolean isIdentifier(String name) {
        if (Utility.isBlank(name)) {
            return false;
        }
        return isIdentifier.matcher(name).matches() && !isAllNumeric.matcher(name).matches();
    }

    private Identifiers(Builder builder) {
        this.identifierQuoteString = builder.isIdentifierQuoteStringSet() ? builder.identifierQuoteString : "\"";
        this.identifierQuotingStrategy = builder.identifierQuotingStrategy;
        this.reservedWords = builder.reservedWords;
    }

    public String getIdentifierQuoteString() {
        return this.identifierQuoteString;
    }

    public IdentifierQuotingStrategy getIdentifierQuotingStrategy() {
        return this.identifierQuotingStrategy;
    }

    public Collection<String> getReservedWords() {
        return new HashSet<String>(this.reservedWords);
    }

    public boolean isQuotedName(String name) {
        if (Utility.isBlank(name) || this.identifierQuoteString.isEmpty() || this.identifierQuotingStrategy == IdentifierQuotingStrategy.quote_none) {
            return false;
        }
        int quoteLength = this.identifierQuoteString.length();
        return name.startsWith(this.identifierQuoteString) && name.endsWith(this.identifierQuoteString) && name.length() >= quoteLength * 2;
    }

    public boolean isReservedWord(String word) {
        return !Utility.isBlank(word) && this.reservedWords.contains(word.trim().toUpperCase());
    }

    public boolean isToBeQuoted(String name) {
        if (name == null || name.isEmpty() || this.isQuotedName(name)) {
            return false;
        }
        switch (this.identifierQuotingStrategy) {
            case quote_none: {
                return false;
            }
            case quote_all: {
                return true;
            }
            case quote_if_special_characters: {
                return !Identifiers.isIdentifier(name);
            }
        }
        return !Identifiers.isIdentifier(name) || this.isReservedWord(name);
    }

    public String quoteFullName(DatabaseObject databaseObject) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, databaseObject);
        return buffer.toString();
    }

    public String quoteFullName(DatabaseObject parent, String name) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, parent, name);
        return buffer.toString();
    }

    public <P extends DatabaseObject> String quoteFullName(DependantObject<P> dependantObject) {
        if (dependantObject == null) {
            return "";
        }
        return this.quoteFullName((DatabaseObject)dependantObject.getParent(), dependantObject.getName());
    }

    public String quoteFullName(Schema schema) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteFullName(buffer, schema);
        return buffer.toString();
    }

    public String quoteName(NamedObject namedObject) {
        if (namedObject == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(512);
        this.quoteName(buffer, namedObject.getName());
        return buffer.toString();
    }

    public String quoteName(String name) {
        StringBuilder buffer = new StringBuilder(512);
        this.quoteName(buffer, name);
        return buffer.toString();
    }

    public <P extends DatabaseObject> String quoteShortName(DependantObject<P> dependantObject) {
        String parentName;
        if (dependantObject == null) {
            return "";
        }
        DatabaseObject parent = (DatabaseObject)dependantObject.getParent();
        StringBuilder buffer = new StringBuilder(64);
        if (parent != null && !Utility.isBlank(parentName = parent.getName())) {
            this.quoteName(buffer, parentName);
            buffer.append('.');
        }
        this.quoteName(buffer, dependantObject.getName());
        return buffer.toString();
    }

    private void quoteFullName(StringBuilder buffer, DatabaseObject databaseObject) {
        Objects.requireNonNull(buffer, "No buffer provided");
        if (databaseObject == null) {
            return;
        }
        Schema schema = databaseObject.getSchema();
        String name = databaseObject.getName();
        this.quoteFullName(buffer, schema);
        if (!Utility.isBlank(name)) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            this.quoteName(buffer, name);
        }
    }

    private void quoteFullName(StringBuilder buffer, DatabaseObject parent, String name) {
        Objects.requireNonNull(buffer, "No buffer provided");
        this.quoteFullName(buffer, parent);
        if (!Utility.isBlank(name)) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            this.quoteName(buffer, name);
        }
    }

    private void quoteFullName(StringBuilder buffer, Schema schema) {
        boolean hasSchemaName;
        Objects.requireNonNull(buffer, "No buffer provided");
        if (schema == null) {
            return;
        }
        String catalogName = schema.getCatalogName();
        String schemaName = schema.getName();
        boolean hasCatalogName = !Utility.isBlank(catalogName);
        boolean bl = hasSchemaName = !Utility.isBlank(schemaName);
        if (hasCatalogName) {
            this.quoteName(buffer, catalogName);
        }
        if (hasCatalogName && hasSchemaName) {
            buffer.append(".");
        }
        if (hasSchemaName) {
            this.quoteName(buffer, schemaName);
        }
    }

    private void quoteName(StringBuilder buffer, String name) {
        Objects.requireNonNull(buffer, "No buffer provided");
        if (Utility.isBlank(name)) {
            return;
        }
        if (this.isToBeQuoted(name)) {
            buffer.append(this.identifierQuoteString).append(name).append(this.identifierQuoteString);
        } else {
            buffer.append(name);
        }
    }

    public static class Builder {
        private final Collection<String> reservedWords = Builder.loadSql2003ReservedWords();
        private String identifierQuoteString;
        private IdentifierQuotingStrategy identifierQuotingStrategy = IdentifierQuotingStrategy.quote_if_special_characters_and_reserved_words;

        private static Collection<String> loadSql2003ReservedWords() {
            HashSet<String> reservedWords = new HashSet<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Identifiers.class.getResourceAsStream("/sql2003_reserved_words.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (Utility.isBlank(line)) continue;
                    reservedWords.add(line);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not read list of SQL 2003 reserved words", (Throwable)e);
            }
            if (reservedWords.isEmpty()) {
                throw new SchemaCrawlerRuntimeException("No SQL 2003 reserved words found");
            }
            return Builder.toUpperCase(reservedWords);
        }

        private static Collection<String> lookupReservedWords(DatabaseMetaData metaData) {
            String sqlKeywords = "";
            try {
                sqlKeywords = metaData.getSQLKeywords();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not retrieve SQL keywords metadata", (Throwable)e);
            }
            return Builder.toUpperCase(Arrays.asList(sqlKeywords.split(",")));
        }

        private static Collection<String> toUpperCase(Iterable<String> words) {
            HashSet<String> upperCaseWords = new HashSet<String>();
            if (words != null) {
                for (String word : words) {
                    if (Utility.isBlank(word)) continue;
                    upperCaseWords.add(word.toUpperCase());
                }
            }
            return upperCaseWords;
        }

        private Builder() {
        }

        public Identifiers build() {
            return new Identifiers(this);
        }

        public Builder withConnection(Connection connection) throws SQLException {
            String metaDataIdentifierQuoteString;
            Objects.requireNonNull(connection, "No connection provided");
            DatabaseMetaData metaData = Objects.requireNonNull(connection.getMetaData(), "No database metadata obtained");
            this.reservedWords.addAll(Builder.lookupReservedWords(metaData));
            if (!this.isIdentifierQuoteStringSet() && (metaDataIdentifierQuoteString = metaData.getIdentifierQuoteString()) != null) {
                this.identifierQuoteString = metaDataIdentifierQuoteString;
            }
            return this;
        }

        public Builder withConnectionIfPossible(Connection connection) {
            try {
                this.withConnection(connection);
            }
            catch (NullPointerException | SQLException exception) {
                // empty catch block
            }
            return this;
        }

        public Builder withIdentifierQuoteString(String identifierQuoteString) {
            this.identifierQuoteString = Utility.isBlank(identifierQuoteString) ? "" : identifierQuoteString;
            return this;
        }

        public Builder withIdentifierQuotingStrategy(IdentifierQuotingStrategy identifierQuotingStrategy) {
            this.identifierQuotingStrategy = identifierQuotingStrategy == null ? IdentifierQuotingStrategy.quote_none : identifierQuotingStrategy;
            return this;
        }

        private boolean isIdentifierQuoteStringSet() {
            return this.identifierQuoteString != null;
        }
    }
}

