/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.utility;

import java.io.Serializable;
import java.util.Set;
import sf.util.TemplatingUtility;
import sf.util.Utility;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 2820769346069413473L;
    private final String name;
    private final String query;

    public Query(String name, String query) {
        if (Utility.isBlank(name)) {
            throw new IllegalArgumentException("No query name provided");
        }
        if (Utility.isBlank(query)) {
            throw new IllegalArgumentException("No query SQL provided");
        }
        this.name = name;
        this.query = query;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isQueryOver() {
        Set<String> keys = TemplatingUtility.extractTemplateVariables(this.query);
        return keys.contains("table");
    }

    public String toString() {
        return String.format("-- \"%s\"%n%s", this.name, this.query);
    }
}

