/*
 * Decompiled with CFR 0.152.
 */
package sf.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import sf.util.IOUtility;
import sf.util.SchemaCrawlerLogger;
import sf.util.StringFormat;
import sf.util.Utility;

public class ProcessExecutor
implements Callable<Integer> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ProcessExecutor.class.getName());
    private List<String> command;
    private Path processOutput;
    private Path processError;
    private int exitCode;

    @Override
    public Integer call() throws Exception {
        Objects.requireNonNull(this.command, "No command provided");
        try {
            this.processOutput = IOUtility.createTempFilePath("temp", "stdout");
            this.processError = IOUtility.createTempFilePath("temp", "stderr");
            if (this.command.isEmpty()) {
                return null;
            }
            LOGGER.log(Level.CONFIG, new StringFormat("Executing:%n%s", this.command));
            ProcessBuilder processBuilder = new ProcessBuilder(this.command);
            processBuilder.redirectOutput(this.processOutput.toFile());
            processBuilder.redirectError(this.processError.toFile());
            Process process = processBuilder.start();
            this.exitCode = process.waitFor();
        }
        catch (Throwable t) {
            if (this.exitCode == 0) {
                this.exitCode = Integer.MIN_VALUE;
            }
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
        }
        return this.exitCode;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Path getProcessError() {
        return this.processError;
    }

    public Path getProcessOutput() {
        return this.processOutput;
    }

    public void setCommandLine(List<String> args) {
        this.command = this.quoteCommandLine(args);
    }

    protected List<String> quoteCommandLine(List<String> args) {
        Objects.requireNonNull(args, "No command provided");
        if (args.isEmpty()) {
            throw new IllegalArgumentException("No command provided");
        }
        ArrayList<String> command = new ArrayList<String>();
        for (String arg : args) {
            if (Utility.isBlank(arg)) continue;
            if (Utility.containsWhitespace(arg)) {
                command.add(String.format("\"%s\"", arg));
                continue;
            }
            command.add(arg);
        }
        return command;
    }
}

