/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf.parser;

import com.google.protobuf.compiler.PluginProtos;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ParserUtil {
    public static Map<String, String> getGeneratorParameters(PluginProtos.CodeGeneratorRequest request) {
        if (!request.hasParameter()) {
            return Collections.emptyMap();
        }
        return ParserUtil.parseGeneratorParameters(request.getParameter());
    }

    public static Map<String, String> parseGeneratorParameters(String parameter) {
        String[] parts;
        if (parameter == null || parameter.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String part : parts = parameter.split(",")) {
            int equalsIndex = part.indexOf("=");
            if (equalsIndex == -1) {
                map.put(part, "");
                continue;
            }
            String key = part.substring(0, equalsIndex);
            String value = part.substring(equalsIndex + 1);
            map.put(key, value);
        }
        return map;
    }

    public static PluginProtos.CodeGeneratorResponse asErrorWithStackTrace(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");){
            e.printStackTrace(ps);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)"UTF-8 encoding not supported");
        }
        String errorWithStackTrace = new String(baos.toByteArray(), StandardCharsets.UTF_8);
        return PluginProtos.CodeGeneratorResponse.newBuilder().setError(errorWithStackTrace).build();
    }

    public static PluginProtos.CodeGeneratorResponse asError(String errorMessage) {
        return PluginProtos.CodeGeneratorResponse.newBuilder().setError(errorMessage).build();
    }
}

