/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.hebi.quickbuf.ByteUtil;
import us.hebi.quickbuf.InvalidProtocolBufferException;
import us.hebi.quickbuf.ProtoSource;
import us.hebi.quickbuf.ProtoUtil;
import us.hebi.quickbuf.RepeatedField;
import us.hebi.quickbuf.UnsafeAccess;

class ArraySource
extends ProtoSource {
    private int bufferSizeAfterLimit;
    protected int offset;
    protected int limit;
    protected int position;
    protected byte[] buffer;

    ArraySource() {
    }

    @Override
    protected ProtoSource resetInternalState() {
        super.resetInternalState();
        this.bufferSizeAfterLimit = 0;
        return this;
    }

    @Override
    public int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
        if (byteLimit < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if ((byteLimit += this.position) > this.limit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int oldLimit = this.currentLimit;
        this.currentLimit = byteLimit;
        this.recomputeBufferSizeAfterLimit();
        return oldLimit;
    }

    @Override
    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
        this.recomputeBufferSizeAfterLimit();
    }

    @Override
    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        return this.currentLimit - this.position;
    }

    @Override
    public boolean isAtEnd() {
        return this.position == this.limit;
    }

    @Override
    public int getTotalBytesRead() {
        return this.position - this.offset;
    }

    @Override
    public void rewindTo(int position) {
        if (position < 0 || position > this.limit) {
            throw new IllegalArgumentException("position out of bounds");
        }
        this.position = this.offset + position;
    }

    protected void requireRemaining(int numBytes) throws IOException {
        if (numBytes < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (numBytes > this.limit - this.position) {
            if (this.currentLimit != Integer.MAX_VALUE) {
                this.position = this.currentLimit;
            }
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }

    private void recomputeBufferSizeAfterLimit() {
        this.limit += this.bufferSizeAfterLimit;
        int bufferEnd = this.limit;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.limit -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    protected int getRemainingRepeatedFieldCount(int tag) throws IOException {
        int arrayLength = 1;
        int startPos = this.getTotalBytesRead();
        this.skipField(tag);
        while (this.readTag() == tag) {
            this.skipField(tag);
            ++arrayLength;
        }
        this.rewindTo(startPos);
        return arrayLength;
    }

    protected int getRemainingVarintCount() throws IOException {
        int position = this.getTotalBytesRead();
        int count = 0;
        while (!this.isAtEnd()) {
            this.readRawVarint32();
            ++count;
        }
        this.rewindTo(position);
        return count;
    }

    @Override
    protected void reserveRepeatedFieldCapacity(RepeatedField<?, ?> store, int tag) throws IOException {
        if (store.remainingCapacity() == 0) {
            store.reserve(this.getRemainingRepeatedFieldCount(tag));
        }
    }

    @Override
    protected void reservePackedVarintCapacity(RepeatedField<?, ?> store) throws IOException {
        if (store.remainingCapacity() == 0) {
            store.reserve(this.getRemainingVarintCount());
        }
    }

    @Override
    public ProtoSource setInput(byte[] buffer, long off, int len) {
        if (off < 0L || len < 0 || off > (long)buffer.length || off + (long)len > (long)buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buffer = buffer;
        this.position = this.offset = (int)off;
        this.limit = this.offset + len;
        return this.resetInternalState();
    }

    @Override
    public ProtoSource setInput(ByteBuffer buffer) {
        ProtoUtil.checkArgument(!buffer.isDirect(), "ArraySource does not support direct buffers");
        ProtoUtil.checkArgument(!buffer.isReadOnly() || UnsafeAccess.BufferAccess.isAvailable(), "Buffer is read only and can't be accessed on this platform");
        return ByteUtil.setRawInput(this, buffer);
    }

    @Override
    public ProtoSource clear() {
        return this.setInput(ProtoUtil.EMPTY_BYTE_ARRAY);
    }

    @Override
    public void skipRawBytes(int size) throws IOException {
        this.require(size);
    }

    @Override
    public byte readRawByte() throws IOException {
        if (this.position == this.limit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        return this.buffer[this.position++];
    }

    @Override
    public short readRawLittleEndian16() throws IOException {
        return ByteUtil.readLittleEndian16(this.buffer, this.require(2));
    }

    @Override
    public int readRawLittleEndian32() throws IOException {
        return ByteUtil.readLittleEndian32(this.buffer, this.require(4));
    }

    @Override
    public long readRawLittleEndian64() throws IOException {
        return ByteUtil.readLittleEndian64(this.buffer, this.require(8));
    }

    @Override
    public float readFloat() throws IOException {
        return ByteUtil.readFloat(this.buffer, this.require(4));
    }

    @Override
    public double readDouble() throws IOException {
        return ByteUtil.readDouble(this.buffer, this.require(8));
    }

    @Override
    public void readRawBytes(byte[] values, int offset, int length) throws IOException {
        ByteUtil.readBytes(this.buffer, this.require(length), values, offset, length);
    }

    @Override
    protected void readRawFixed32s(int[] values, int offset, int length) throws IOException {
        ByteUtil.readLittleEndian32s(this.buffer, this.require(length * 4), values, offset, length);
    }

    @Override
    protected void readRawFixed64s(long[] values, int offset, int length) throws IOException {
        ByteUtil.readLittleEndian64s(this.buffer, this.require(length * 8), values, offset, length);
    }

    @Override
    protected void readRawFloats(float[] values, int offset, int length) throws IOException {
        ByteUtil.readFloats(this.buffer, this.require(length * 4), values, offset, length);
    }

    @Override
    protected void readRawDoubles(double[] values, int offset, int length) throws IOException {
        ByteUtil.readDoubles(this.buffer, this.require(length * 8), values, offset, length);
    }

    private int require(int numBytes) throws IOException {
        this.requireRemaining(numBytes);
        try {
            int n = this.position;
            return n;
        }
        finally {
            this.position += numBytes;
        }
    }

    static class DirectArraySource
    extends ArraySource {
        private long baseOffset;
        Object gcRef;

        DirectArraySource() {
            if (!UnsafeAccess.isAvailable()) {
                throw new AssertionError((Object)"DirectArraySource requires access to sun.misc.Unsafe");
            }
        }

        @Override
        public ProtoSource setInput(byte[] buffer, long offset, int length) {
            this.gcRef = null;
            if (buffer != null) {
                this.baseOffset = UnsafeAccess.BYTE_ARRAY_OFFSET;
                return super.setInput(buffer, offset, length);
            }
            if (offset <= 0L) {
                throw new NullPointerException("null reference with invalid base address");
            }
            if (length < 0) {
                throw new ArrayIndexOutOfBoundsException("negative length");
            }
            this.buffer = null;
            this.baseOffset = offset;
            this.offset = 0;
            this.position = 0;
            this.limit = length;
            return this.resetInternalState();
        }

        @Override
        public ProtoSource setInput(ByteBuffer buffer) {
            return ByteUtil.setRawInput(this, buffer);
        }

        @Override
        public void skipRawBytes(int size) throws IOException {
            this.require(size);
        }

        @Override
        public byte readRawByte() throws IOException {
            if (this.position == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return UnsafeAccess.UNSAFE.getByte(this.buffer, this.baseOffset + (long)this.position++);
        }

        @Override
        public short readRawLittleEndian16() throws IOException {
            return ByteUtil.readUnsafeLittleEndian16(this.buffer, this.require(2));
        }

        @Override
        public int readRawLittleEndian32() throws IOException {
            return ByteUtil.readUnsafeLittleEndian32(this.buffer, this.require(4));
        }

        @Override
        public long readRawLittleEndian64() throws IOException {
            return ByteUtil.readUnsafeLittleEndian64(this.buffer, this.require(8));
        }

        @Override
        public float readFloat() throws IOException {
            return ByteUtil.readUnsafeFloat(this.buffer, this.require(4));
        }

        @Override
        public double readDouble() throws IOException {
            return ByteUtil.readUnsafeDouble(this.buffer, this.require(8));
        }

        @Override
        public void readRawBytes(byte[] values, int offset, int length) throws IOException {
            ProtoUtil.checkBounds(values, offset, length);
            ByteUtil.readUnsafeBytes(this.buffer, this.require(length), values, offset, length);
        }

        @Override
        protected void readRawFixed32s(int[] values, int offset, int length) throws IOException {
            ByteUtil.readUnsafeLittleEndian32s(this.buffer, this.require(length * 4), values, offset, length);
        }

        @Override
        protected void readRawFixed64s(long[] values, int offset, int length) throws IOException {
            ByteUtil.readUnsafeLittleEndian64s(this.buffer, this.require(length * 8), values, offset, length);
        }

        @Override
        protected void readRawFloats(float[] values, int offset, int length) throws IOException {
            ByteUtil.readUnsafeFloats(this.buffer, this.require(length * 4), values, offset, length);
        }

        @Override
        protected void readRawDoubles(double[] values, int offset, int length) throws IOException {
            ByteUtil.readUnsafeDoubles(this.buffer, this.require(length * 8), values, offset, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long require(int numBytes) throws IOException {
            this.requireRemaining(numBytes);
            try {
                long l = this.baseOffset + (long)this.position;
                return l;
            }
            finally {
                this.position += numBytes;
            }
        }
    }
}

