/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.hebi.quickbuf.RepeatedByte;

public final class Descriptors {
    private Descriptors() {
    }

    public static class Descriptor
    extends GenericDescriptor {
        final FileDescriptor file;

        private Descriptor(String fullName, String name, FileDescriptor file, RepeatedByte bytes, int offset, int length) {
            super(fullName, name, bytes, offset, length);
            this.file = file;
        }

        @Override
        public FileDescriptor getFile() {
            return this.file;
        }
    }

    public static class FileDescriptor
    extends GenericDescriptor {
        final String protoPackage;
        final List<FileDescriptor> dependencies;
        final List<Descriptor> containedTypes = new ArrayList<Descriptor>();

        public static FileDescriptor internalBuildGeneratedFileFrom(String name, String protoPackage, RepeatedByte bytes, FileDescriptor ... dependencies) {
            return new FileDescriptor(name, protoPackage, bytes, Arrays.asList(dependencies));
        }

        public Descriptor internalContainedType(int offset, int length, String name, String fullName) {
            Descriptor type = new Descriptor(fullName, name, this, this.bytes, offset, length);
            this.containedTypes.add(type);
            return type;
        }

        public String getPackage() {
            return this.protoPackage;
        }

        @Override
        public FileDescriptor getFile() {
            return this;
        }

        public List<FileDescriptor> getDependencies() {
            return Collections.unmodifiableList(this.dependencies);
        }

        public List<Descriptor> getAllContainedTypes() {
            return Collections.unmodifiableList(this.containedTypes);
        }

        public List<Descriptor> getAllKnownTypes() {
            return FileDescriptor.getAllKnownTypes(this, new ArrayList<Descriptor>());
        }

        private static List<Descriptor> getAllKnownTypes(FileDescriptor file, List<Descriptor> list) {
            for (FileDescriptor dependency : file.dependencies) {
                FileDescriptor.getAllKnownTypes(dependency, list);
            }
            list.addAll(file.containedTypes);
            return list;
        }

        private FileDescriptor(String fileName, String protoPackage, RepeatedByte bytes, List<FileDescriptor> dependencies) {
            super(fileName, fileName, bytes, 0, bytes.length());
            this.protoPackage = protoPackage;
            this.dependencies = dependencies;
        }
    }

    public static abstract class GenericDescriptor {
        final String fullName;
        final String name;
        final RepeatedByte bytes;
        final int offset;
        final int length;

        public byte[] toProtoBytes() {
            return Arrays.copyOfRange(this.bytes.array, this.offset, this.offset + this.length);
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public abstract FileDescriptor getFile();

        private GenericDescriptor(String fullName, String name, RepeatedByte bytes, int offset, int length) {
            this.fullName = fullName;
            this.name = name;
            this.bytes = bytes;
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            return "descriptor{" + this.fullName + "}";
        }
    }
}

