/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.quickbuf;

import us.hebi.quickbuf.JdkMethods;

public class JdkMath {
    static final boolean HAS_MULTIPLY_HIGH = JdkMath.hasMultiplyHigh0();

    public static long multiplyHigh(long x, long y) {
        if (HAS_MULTIPLY_HIGH) {
            return JdkMethods.multiplyHigh(x, y);
        }
        if (x < 0L || y < 0L) {
            long x1 = x >> 32;
            long x2 = x & 0xFFFFFFFFL;
            long y1 = y >> 32;
            long y2 = y & 0xFFFFFFFFL;
            long z2 = x2 * y2;
            long t = x1 * y2 + (z2 >>> 32);
            long z1 = t & 0xFFFFFFFFL;
            long z0 = t >> 32;
            return x1 * y1 + z0 + ((z1 += x2 * y1) >> 32);
        }
        long x1 = x >>> 32;
        long y1 = y >>> 32;
        long x2 = x & 0xFFFFFFFFL;
        long y2 = y & 0xFFFFFFFFL;
        long A = x1 * y1;
        long B = x2 * y2;
        long C = (x1 + x2) * (y1 + y2);
        long K = C - A - B;
        return ((B >>> 32) + K >>> 32) + A;
    }

    private static boolean hasMultiplyHigh0() {
        try {
            JdkMethods.multiplyHigh(0L, 0L);
            return true;
        }
        catch (NoSuchMethodError oldRuntime) {
            return false;
        }
    }
}

